# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .dr_protection_group_member import DrProtectionGroupMember
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrProtectionGroupMemberComputeInstanceMovable(DrProtectionGroupMember):
    """
    Properties for a Movable Compute Instance member of a DR Protection Group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrProtectionGroupMemberComputeInstanceMovable object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.DrProtectionGroupMemberComputeInstanceMovable.member_type` attribute
        of this class is ``COMPUTE_INSTANCE_MOVABLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this DrProtectionGroupMemberComputeInstanceMovable.
            Allowed values for this property are: "COMPUTE_INSTANCE", "COMPUTE_INSTANCE_MOVABLE", "COMPUTE_INSTANCE_NON_MOVABLE", "VOLUME_GROUP", "DATABASE", "AUTONOMOUS_DATABASE"
        :type member_type: str

        :param is_retain_fault_domain:
            The value to assign to the is_retain_fault_domain property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type is_retain_fault_domain: bool

        :param destination_capacity_reservation_id:
            The value to assign to the destination_capacity_reservation_id property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type destination_capacity_reservation_id: str

        :param vnic_mappings:
            The value to assign to the vnic_mappings property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type vnic_mappings: list[oci.disaster_recovery.models.ComputeInstanceMovableVnicMapping]

        :param destination_compartment_id:
            The value to assign to the destination_compartment_id property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type destination_compartment_id: str

        :param destination_dedicated_vm_host_id:
            The value to assign to the destination_dedicated_vm_host_id property of this DrProtectionGroupMemberComputeInstanceMovable.
        :type destination_dedicated_vm_host_id: str

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'is_retain_fault_domain': 'bool',
            'destination_capacity_reservation_id': 'str',
            'vnic_mappings': 'list[ComputeInstanceMovableVnicMapping]',
            'destination_compartment_id': 'str',
            'destination_dedicated_vm_host_id': 'str'
        }

        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'is_retain_fault_domain': 'isRetainFaultDomain',
            'destination_capacity_reservation_id': 'destinationCapacityReservationId',
            'vnic_mappings': 'vnicMappings',
            'destination_compartment_id': 'destinationCompartmentId',
            'destination_dedicated_vm_host_id': 'destinationDedicatedVmHostId'
        }

        self._member_id = None
        self._member_type = None
        self._is_retain_fault_domain = None
        self._destination_capacity_reservation_id = None
        self._vnic_mappings = None
        self._destination_compartment_id = None
        self._destination_dedicated_vm_host_id = None
        self._member_type = 'COMPUTE_INSTANCE_MOVABLE'

    @property
    def is_retain_fault_domain(self):
        """
        Gets the is_retain_fault_domain of this DrProtectionGroupMemberComputeInstanceMovable.
        A flag indicating if this compute instance should be moved to the same fault domain.
        Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.

        Example: `false`


        :return: The is_retain_fault_domain of this DrProtectionGroupMemberComputeInstanceMovable.
        :rtype: bool
        """
        return self._is_retain_fault_domain

    @is_retain_fault_domain.setter
    def is_retain_fault_domain(self, is_retain_fault_domain):
        """
        Sets the is_retain_fault_domain of this DrProtectionGroupMemberComputeInstanceMovable.
        A flag indicating if this compute instance should be moved to the same fault domain.
        Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.

        Example: `false`


        :param is_retain_fault_domain: The is_retain_fault_domain of this DrProtectionGroupMemberComputeInstanceMovable.
        :type: bool
        """
        self._is_retain_fault_domain = is_retain_fault_domain

    @property
    def destination_capacity_reservation_id(self):
        """
        Gets the destination_capacity_reservation_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the capacity reservation in the destination region using which this compute instance
        should be launched.

        Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`


        :return: The destination_capacity_reservation_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :rtype: str
        """
        return self._destination_capacity_reservation_id

    @destination_capacity_reservation_id.setter
    def destination_capacity_reservation_id(self, destination_capacity_reservation_id):
        """
        Sets the destination_capacity_reservation_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the capacity reservation in the destination region using which this compute instance
        should be launched.

        Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`


        :param destination_capacity_reservation_id: The destination_capacity_reservation_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :type: str
        """
        self._destination_capacity_reservation_id = destination_capacity_reservation_id

    @property
    def vnic_mappings(self):
        """
        Gets the vnic_mappings of this DrProtectionGroupMemberComputeInstanceMovable.
        A list of compute instance VNIC mappings.


        :return: The vnic_mappings of this DrProtectionGroupMemberComputeInstanceMovable.
        :rtype: list[oci.disaster_recovery.models.ComputeInstanceMovableVnicMapping]
        """
        return self._vnic_mappings

    @vnic_mappings.setter
    def vnic_mappings(self, vnic_mappings):
        """
        Sets the vnic_mappings of this DrProtectionGroupMemberComputeInstanceMovable.
        A list of compute instance VNIC mappings.


        :param vnic_mappings: The vnic_mappings of this DrProtectionGroupMemberComputeInstanceMovable.
        :type: list[oci.disaster_recovery.models.ComputeInstanceMovableVnicMapping]
        """
        self._vnic_mappings = vnic_mappings

    @property
    def destination_compartment_id(self):
        """
        Gets the destination_compartment_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the compartment for this compute instance in the destination region.

        Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`


        :return: The destination_compartment_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :rtype: str
        """
        return self._destination_compartment_id

    @destination_compartment_id.setter
    def destination_compartment_id(self, destination_compartment_id):
        """
        Sets the destination_compartment_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the compartment for this compute instance in the destination region.

        Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`


        :param destination_compartment_id: The destination_compartment_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :type: str
        """
        self._destination_compartment_id = destination_compartment_id

    @property
    def destination_dedicated_vm_host_id(self):
        """
        Gets the destination_dedicated_vm_host_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the dedicated VM Host for this compute instance in the destination region.

        Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`


        :return: The destination_dedicated_vm_host_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :rtype: str
        """
        return self._destination_dedicated_vm_host_id

    @destination_dedicated_vm_host_id.setter
    def destination_dedicated_vm_host_id(self, destination_dedicated_vm_host_id):
        """
        Sets the destination_dedicated_vm_host_id of this DrProtectionGroupMemberComputeInstanceMovable.
        The OCID of the dedicated VM Host for this compute instance in the destination region.

        Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`


        :param destination_dedicated_vm_host_id: The destination_dedicated_vm_host_id of this DrProtectionGroupMemberComputeInstanceMovable.
        :type: str
        """
        self._destination_dedicated_vm_host_id = destination_dedicated_vm_host_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
