# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 1.0.017


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TransferJob(object):
    """
    TransferJob model.
    """

    #: A constant which can be used with the device_type property of a TransferJob.
    #: This constant has a value of "DISK"
    DEVICE_TYPE_DISK = "DISK"

    #: A constant which can be used with the device_type property of a TransferJob.
    #: This constant has a value of "APPLIANCE"
    DEVICE_TYPE_APPLIANCE = "APPLIANCE"

    #: A constant which can be used with the lifecycle_state property of a TransferJob.
    #: This constant has a value of "INITIATED"
    LIFECYCLE_STATE_INITIATED = "INITIATED"

    #: A constant which can be used with the lifecycle_state property of a TransferJob.
    #: This constant has a value of "PREPARING"
    LIFECYCLE_STATE_PREPARING = "PREPARING"

    #: A constant which can be used with the lifecycle_state property of a TransferJob.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a TransferJob.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a TransferJob.
    #: This constant has a value of "CLOSED"
    LIFECYCLE_STATE_CLOSED = "CLOSED"

    def __init__(self, **kwargs):
        """
        Initializes a new TransferJob object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this TransferJob.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this TransferJob.
        :type compartment_id: str

        :param upload_bucket_name:
            The value to assign to the upload_bucket_name property of this TransferJob.
        :type upload_bucket_name: str

        :param display_name:
            The value to assign to the display_name property of this TransferJob.
        :type display_name: str

        :param label:
            The value to assign to the label property of this TransferJob.
        :type label: str

        :param creation_time:
            The value to assign to the creation_time property of this TransferJob.
        :type creation_time: datetime

        :param device_type:
            The value to assign to the device_type property of this TransferJob.
            Allowed values for this property are: "DISK", "APPLIANCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type device_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TransferJob.
            Allowed values for this property are: "INITIATED", "PREPARING", "ACTIVE", "DELETED", "CLOSED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param attached_transfer_appliance_labels:
            The value to assign to the attached_transfer_appliance_labels property of this TransferJob.
        :type attached_transfer_appliance_labels: list[str]

        :param attached_transfer_package_labels:
            The value to assign to the attached_transfer_package_labels property of this TransferJob.
        :type attached_transfer_package_labels: list[str]

        :param attached_transfer_device_labels:
            The value to assign to the attached_transfer_device_labels property of this TransferJob.
        :type attached_transfer_device_labels: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this TransferJob.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this TransferJob.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'upload_bucket_name': 'str',
            'display_name': 'str',
            'label': 'str',
            'creation_time': 'datetime',
            'device_type': 'str',
            'lifecycle_state': 'str',
            'attached_transfer_appliance_labels': 'list[str]',
            'attached_transfer_package_labels': 'list[str]',
            'attached_transfer_device_labels': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'upload_bucket_name': 'uploadBucketName',
            'display_name': 'displayName',
            'label': 'label',
            'creation_time': 'creationTime',
            'device_type': 'deviceType',
            'lifecycle_state': 'lifecycleState',
            'attached_transfer_appliance_labels': 'attachedTransferApplianceLabels',
            'attached_transfer_package_labels': 'attachedTransferPackageLabels',
            'attached_transfer_device_labels': 'attachedTransferDeviceLabels',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._compartment_id = None
        self._upload_bucket_name = None
        self._display_name = None
        self._label = None
        self._creation_time = None
        self._device_type = None
        self._lifecycle_state = None
        self._attached_transfer_appliance_labels = None
        self._attached_transfer_package_labels = None
        self._attached_transfer_device_labels = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this TransferJob.

        :return: The id of this TransferJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TransferJob.

        :param id: The id of this TransferJob.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this TransferJob.

        :return: The compartment_id of this TransferJob.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this TransferJob.

        :param compartment_id: The compartment_id of this TransferJob.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def upload_bucket_name(self):
        """
        Gets the upload_bucket_name of this TransferJob.

        :return: The upload_bucket_name of this TransferJob.
        :rtype: str
        """
        return self._upload_bucket_name

    @upload_bucket_name.setter
    def upload_bucket_name(self, upload_bucket_name):
        """
        Sets the upload_bucket_name of this TransferJob.

        :param upload_bucket_name: The upload_bucket_name of this TransferJob.
        :type: str
        """
        self._upload_bucket_name = upload_bucket_name

    @property
    def display_name(self):
        """
        Gets the display_name of this TransferJob.

        :return: The display_name of this TransferJob.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this TransferJob.

        :param display_name: The display_name of this TransferJob.
        :type: str
        """
        self._display_name = display_name

    @property
    def label(self):
        """
        Gets the label of this TransferJob.

        :return: The label of this TransferJob.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this TransferJob.

        :param label: The label of this TransferJob.
        :type: str
        """
        self._label = label

    @property
    def creation_time(self):
        """
        Gets the creation_time of this TransferJob.

        :return: The creation_time of this TransferJob.
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """
        Sets the creation_time of this TransferJob.

        :param creation_time: The creation_time of this TransferJob.
        :type: datetime
        """
        self._creation_time = creation_time

    @property
    def device_type(self):
        """
        Gets the device_type of this TransferJob.
        Allowed values for this property are: "DISK", "APPLIANCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The device_type of this TransferJob.
        :rtype: str
        """
        return self._device_type

    @device_type.setter
    def device_type(self, device_type):
        """
        Sets the device_type of this TransferJob.

        :param device_type: The device_type of this TransferJob.
        :type: str
        """
        allowed_values = ["DISK", "APPLIANCE"]
        if not value_allowed_none_or_none_sentinel(device_type, allowed_values):
            device_type = 'UNKNOWN_ENUM_VALUE'
        self._device_type = device_type

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this TransferJob.
        Allowed values for this property are: "INITIATED", "PREPARING", "ACTIVE", "DELETED", "CLOSED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this TransferJob.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this TransferJob.

        :param lifecycle_state: The lifecycle_state of this TransferJob.
        :type: str
        """
        allowed_values = ["INITIATED", "PREPARING", "ACTIVE", "DELETED", "CLOSED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def attached_transfer_appliance_labels(self):
        """
        Gets the attached_transfer_appliance_labels of this TransferJob.
        Transfer Appliance labels associated with this transfer Job


        :return: The attached_transfer_appliance_labels of this TransferJob.
        :rtype: list[str]
        """
        return self._attached_transfer_appliance_labels

    @attached_transfer_appliance_labels.setter
    def attached_transfer_appliance_labels(self, attached_transfer_appliance_labels):
        """
        Sets the attached_transfer_appliance_labels of this TransferJob.
        Transfer Appliance labels associated with this transfer Job


        :param attached_transfer_appliance_labels: The attached_transfer_appliance_labels of this TransferJob.
        :type: list[str]
        """
        self._attached_transfer_appliance_labels = attached_transfer_appliance_labels

    @property
    def attached_transfer_package_labels(self):
        """
        Gets the attached_transfer_package_labels of this TransferJob.
        Transfer Package labels associated with this transfer Job


        :return: The attached_transfer_package_labels of this TransferJob.
        :rtype: list[str]
        """
        return self._attached_transfer_package_labels

    @attached_transfer_package_labels.setter
    def attached_transfer_package_labels(self, attached_transfer_package_labels):
        """
        Sets the attached_transfer_package_labels of this TransferJob.
        Transfer Package labels associated with this transfer Job


        :param attached_transfer_package_labels: The attached_transfer_package_labels of this TransferJob.
        :type: list[str]
        """
        self._attached_transfer_package_labels = attached_transfer_package_labels

    @property
    def attached_transfer_device_labels(self):
        """
        Gets the attached_transfer_device_labels of this TransferJob.
        Transfer Device labels associated with this transfer Job


        :return: The attached_transfer_device_labels of this TransferJob.
        :rtype: list[str]
        """
        return self._attached_transfer_device_labels

    @attached_transfer_device_labels.setter
    def attached_transfer_device_labels(self, attached_transfer_device_labels):
        """
        Sets the attached_transfer_device_labels of this TransferJob.
        Transfer Device labels associated with this transfer Job


        :param attached_transfer_device_labels: The attached_transfer_device_labels of this TransferJob.
        :type: list[str]
        """
        self._attached_transfer_device_labels = attached_transfer_device_labels

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this TransferJob.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this TransferJob.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this TransferJob.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this TransferJob.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this TransferJob.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this TransferJob.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this TransferJob.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this TransferJob.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
