# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFileSystemDetails(object):
    """
    Details for creating the file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateFileSystemDetails.
        :type availability_domain: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFileSystemDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateFileSystemDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateFileSystemDetails.
        :type kms_key_id: str

        :param source_snapshot_id:
            The value to assign to the source_snapshot_id property of this CreateFileSystemDetails.
        :type source_snapshot_id: str

        :param filesystem_snapshot_policy_id:
            The value to assign to the filesystem_snapshot_policy_id property of this CreateFileSystemDetails.
        :type filesystem_snapshot_policy_id: str

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'kms_key_id': 'str',
            'source_snapshot_id': 'str',
            'filesystem_snapshot_policy_id': 'str'
        }

        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'kms_key_id': 'kmsKeyId',
            'source_snapshot_id': 'sourceSnapshotId',
            'filesystem_snapshot_policy_id': 'filesystemSnapshotPolicyId'
        }

        self._availability_domain = None
        self._compartment_id = None
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._kms_key_id = None
        self._source_snapshot_id = None
        self._filesystem_snapshot_policy_id = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateFileSystemDetails.
        The availability domain to create the file system in.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateFileSystemDetails.
        The availability domain to create the file system in.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this CreateFileSystemDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFileSystemDetails.
        The `OCID`__ of the compartment to create the file system in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFileSystemDetails.
        The `OCID`__ of the compartment to create the file system in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateFileSystemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My file system`


        :return: The display_name of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My file system`


        :param display_name: The display_name of this CreateFileSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair
         with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair
         with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this CreateFileSystemDetails.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The kms_key_id of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this CreateFileSystemDetails.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param kms_key_id: The kms_key_id of this CreateFileSystemDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def source_snapshot_id(self):
        """
        Gets the source_snapshot_id of this CreateFileSystemDetails.
        The `OCID`__ of the snapshot used to create a cloned file system.
        See `Cloning a File System`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm


        :return: The source_snapshot_id of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._source_snapshot_id

    @source_snapshot_id.setter
    def source_snapshot_id(self, source_snapshot_id):
        """
        Sets the source_snapshot_id of this CreateFileSystemDetails.
        The `OCID`__ of the snapshot used to create a cloned file system.
        See `Cloning a File System`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm


        :param source_snapshot_id: The source_snapshot_id of this CreateFileSystemDetails.
        :type: str
        """
        self._source_snapshot_id = source_snapshot_id

    @property
    def filesystem_snapshot_policy_id(self):
        """
        Gets the filesystem_snapshot_policy_id of this CreateFileSystemDetails.
        The `OCID`__ of the associated file system snapshot policy, which
        controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The filesystem_snapshot_policy_id of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._filesystem_snapshot_policy_id

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, filesystem_snapshot_policy_id):
        """
        Sets the filesystem_snapshot_policy_id of this CreateFileSystemDetails.
        The `OCID`__ of the associated file system snapshot policy, which
        controls the frequency of snapshot creation and retention period of the taken snapshots.

        May be unset as a blank value.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param filesystem_snapshot_policy_id: The filesystem_snapshot_policy_id of this CreateFileSystemDetails.
        :type: str
        """
        self._filesystem_snapshot_policy_id = filesystem_snapshot_policy_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
