# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppOutboundAssertionAttributes(object):
    """
    Use to construct the outgoing SAML attributes

    **Added In:** 18.2.6

    **SCIM++ Properties:**
    - caseExact: false
    - idcsCompositeKey: [value]
    - idcsSearchable: true
    - multiValued: false
    - mutability: readOnly
    - required: false
    - returned: default
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppOutboundAssertionAttributes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this AppOutboundAssertionAttributes.
        :type value: str

        :param ref:
            The value to assign to the ref property of this AppOutboundAssertionAttributes.
        :type ref: str

        :param direction:
            The value to assign to the direction property of this AppOutboundAssertionAttributes.
        :type direction: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'direction': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'direction': 'direction'
        }

        self._value = None
        self._ref = None
        self._direction = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this AppOutboundAssertionAttributes.
        Mapped Attribute identifier

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this AppOutboundAssertionAttributes.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AppOutboundAssertionAttributes.
        Mapped Attribute identifier

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this AppOutboundAssertionAttributes.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this AppOutboundAssertionAttributes.
        Mapped Attribute URI

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this AppOutboundAssertionAttributes.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this AppOutboundAssertionAttributes.
        Mapped Attribute URI

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this AppOutboundAssertionAttributes.
        :type: str
        """
        self._ref = ref

    @property
    def direction(self):
        """
        Gets the direction of this AppOutboundAssertionAttributes.
        Mapped Attribute Direction

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The direction of this AppOutboundAssertionAttributes.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this AppOutboundAssertionAttributes.
        Mapped Attribute Direction

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param direction: The direction of this AppOutboundAssertionAttributes.
        :type: str
        """
        self._direction = direction

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
