# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointResult(object):
    """
    The validation status of a specified endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_name:
            The value to assign to the endpoint_name property of this EndpointResult.
        :type endpoint_name: str

        :param url:
            The value to assign to the url property of this EndpointResult.
        :type url: str

        :param status:
            The value to assign to the status property of this EndpointResult.
        :type status: str

        :param violations:
            The value to assign to the violations property of this EndpointResult.
        :type violations: list[oci.log_analytics.models.Violation]

        :param log_endpoints:
            The value to assign to the log_endpoints property of this EndpointResult.
        :type log_endpoints: list[str]

        """
        self.swagger_types = {
            'endpoint_name': 'str',
            'url': 'str',
            'status': 'str',
            'violations': 'list[Violation]',
            'log_endpoints': 'list[str]'
        }

        self.attribute_map = {
            'endpoint_name': 'endpointName',
            'url': 'url',
            'status': 'status',
            'violations': 'violations',
            'log_endpoints': 'logEndpoints'
        }

        self._endpoint_name = None
        self._url = None
        self._status = None
        self._violations = None
        self._log_endpoints = None

    @property
    def endpoint_name(self):
        """
        Gets the endpoint_name of this EndpointResult.
        The endpoint name.


        :return: The endpoint_name of this EndpointResult.
        :rtype: str
        """
        return self._endpoint_name

    @endpoint_name.setter
    def endpoint_name(self, endpoint_name):
        """
        Sets the endpoint_name of this EndpointResult.
        The endpoint name.


        :param endpoint_name: The endpoint_name of this EndpointResult.
        :type: str
        """
        self._endpoint_name = endpoint_name

    @property
    def url(self):
        """
        Gets the url of this EndpointResult.
        The endpoint URL.


        :return: The url of this EndpointResult.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this EndpointResult.
        The endpoint URL.


        :param url: The url of this EndpointResult.
        :type: str
        """
        self._url = url

    @property
    def status(self):
        """
        Gets the status of this EndpointResult.
        The endpoint validation status.


        :return: The status of this EndpointResult.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EndpointResult.
        The endpoint validation status.


        :param status: The status of this EndpointResult.
        :type: str
        """
        self._status = status

    @property
    def violations(self):
        """
        Gets the violations of this EndpointResult.
        The list of violations (if any).


        :return: The violations of this EndpointResult.
        :rtype: list[oci.log_analytics.models.Violation]
        """
        return self._violations

    @violations.setter
    def violations(self, violations):
        """
        Sets the violations of this EndpointResult.
        The list of violations (if any).


        :param violations: The violations of this EndpointResult.
        :type: list[oci.log_analytics.models.Violation]
        """
        self._violations = violations

    @property
    def log_endpoints(self):
        """
        Gets the log_endpoints of this EndpointResult.
        The resolved log endpoints based on the specified list endpoint response.


        :return: The log_endpoints of this EndpointResult.
        :rtype: list[str]
        """
        return self._log_endpoints

    @log_endpoints.setter
    def log_endpoints(self, log_endpoints):
        """
        Sets the log_endpoints of this EndpointResult.
        The resolved log endpoints based on the specified list endpoint response.


        :param log_endpoints: The log_endpoints of this EndpointResult.
        :type: list[str]
        """
        self._log_endpoints = log_endpoints

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
