# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Market(object):
    """
    The model for the market details.
    """

    #: A constant which can be used with the lifecycle_state property of a Market.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Market.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new Market object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Market.
        :type name: str

        :param code:
            The value to assign to the code property of this Market.
        :type code: str

        :param category_code:
            The value to assign to the category_code property of this Market.
        :type category_code: str

        :param realm_code:
            The value to assign to the realm_code property of this Market.
        :type realm_code: str

        :param bill_to_countries:
            The value to assign to the bill_to_countries property of this Market.
        :type bill_to_countries: list[str]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Market.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this Market.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Market.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'name': 'str',
            'code': 'str',
            'category_code': 'str',
            'realm_code': 'str',
            'bill_to_countries': 'list[str]',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }

        self.attribute_map = {
            'name': 'name',
            'code': 'code',
            'category_code': 'categoryCode',
            'realm_code': 'realmCode',
            'bill_to_countries': 'billToCountries',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }

        self._name = None
        self._code = None
        self._category_code = None
        self._realm_code = None
        self._bill_to_countries = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Market.
        The name of the market.


        :return: The name of this Market.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Market.
        The name of the market.


        :param name: The name of this Market.
        :type: str
        """
        self._name = name

    @property
    def code(self):
        """
        **[Required]** Gets the code of this Market.
        The code of the market.


        :return: The code of this Market.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this Market.
        The code of the market.


        :param code: The code of this Market.
        :type: str
        """
        self._code = code

    @property
    def category_code(self):
        """
        **[Required]** Gets the category_code of this Market.
        The category code of the market.


        :return: The category_code of this Market.
        :rtype: str
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """
        Sets the category_code of this Market.
        The category code of the market.


        :param category_code: The category_code of this Market.
        :type: str
        """
        self._category_code = category_code

    @property
    def realm_code(self):
        """
        Gets the realm_code of this Market.
        The realm code of the market.


        :return: The realm_code of this Market.
        :rtype: str
        """
        return self._realm_code

    @realm_code.setter
    def realm_code(self, realm_code):
        """
        Sets the realm_code of this Market.
        The realm code of the market.


        :param realm_code: The realm_code of this Market.
        :type: str
        """
        self._realm_code = realm_code

    @property
    def bill_to_countries(self):
        """
        **[Required]** Gets the bill_to_countries of this Market.
        bill to countries for the market.


        :return: The bill_to_countries of this Market.
        :rtype: list[str]
        """
        return self._bill_to_countries

    @bill_to_countries.setter
    def bill_to_countries(self, bill_to_countries):
        """
        Sets the bill_to_countries of this Market.
        bill to countries for the market.


        :param bill_to_countries: The bill_to_countries of this Market.
        :type: list[str]
        """
        self._bill_to_countries = bill_to_countries

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Market.
        The current state for the market.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Market.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Market.
        The current state for the market.


        :param lifecycle_state: The lifecycle_state of this Market.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Market.
        The date and time the market was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this Market.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Market.
        The date and time the market was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this Market.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this Market.
        The date and time the market was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this Market.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Market.
        The date and time the market was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this Market.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
