# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateOfferAccountDetails(object):
    """
    Private Offer account details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateOfferAccountDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param meter:
            The value to assign to the meter property of this PrivateOfferAccountDetails.
        :type meter: str

        :param sku:
            The value to assign to the sku property of this PrivateOfferAccountDetails.
        :type sku: str

        """
        self.swagger_types = {
            'meter': 'str',
            'sku': 'str'
        }

        self.attribute_map = {
            'meter': 'meter',
            'sku': 'sku'
        }

        self._meter = None
        self._sku = None

    @property
    def meter(self):
        """
        Gets the meter of this PrivateOfferAccountDetails.
        Meter name


        :return: The meter of this PrivateOfferAccountDetails.
        :rtype: str
        """
        return self._meter

    @meter.setter
    def meter(self, meter):
        """
        Sets the meter of this PrivateOfferAccountDetails.
        Meter name


        :param meter: The meter of this PrivateOfferAccountDetails.
        :type: str
        """
        self._meter = meter

    @property
    def sku(self):
        """
        Gets the sku of this PrivateOfferAccountDetails.
        SKU name


        :return: The sku of this PrivateOfferAccountDetails.
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """
        Sets the sku of this PrivateOfferAccountDetails.
        SKU name


        :param sku: The sku of this PrivateOfferAccountDetails.
        :type: str
        """
        self._sku = sku

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
