# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateApplicationDetails(object):
    """
    Request for creating a application against a policy.
    """

    #: A constant which can be used with the type property of a CreateApplicationDetails.
    #: This constant has a value of "ICMP"
    TYPE_ICMP = "ICMP"

    #: A constant which can be used with the type property of a CreateApplicationDetails.
    #: This constant has a value of "ICMP_V6"
    TYPE_ICMP_V6 = "ICMP_V6"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateApplicationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.network_firewall.models.CreateIcmpApplicationDetails`
        * :class:`~oci.network_firewall.models.CreateIcmp6ApplicationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateApplicationDetails.
        :type name: str

        :param type:
            The value to assign to the type property of this CreateApplicationDetails.
            Allowed values for this property are: "ICMP", "ICMP_V6"
        :type type: str

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'type': 'type'
        }

        self._name = None
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'ICMP':
            return 'CreateIcmpApplicationDetails'

        if type == 'ICMP_V6':
            return 'CreateIcmp6ApplicationDetails'
        else:
            return 'CreateApplicationDetails'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateApplicationDetails.
        Name of the application


        :return: The name of this CreateApplicationDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateApplicationDetails.
        Name of the application


        :param name: The name of this CreateApplicationDetails.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this CreateApplicationDetails.
        Describes the type of Application.

        Allowed values for this property are: "ICMP", "ICMP_V6"


        :return: The type of this CreateApplicationDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateApplicationDetails.
        Describes the type of Application.


        :param type: The type of this CreateApplicationDetails.
        :type: str
        """
        allowed_values = ["ICMP", "ICMP_V6"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
