# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RejectAccessRequestDetails(object):
    """
    Summary of why the access request was rejected.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RejectAccessRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param approver_comment:
            The value to assign to the approver_comment property of this RejectAccessRequestDetails.
        :type approver_comment: str

        """
        self.swagger_types = {
            'approver_comment': 'str'
        }

        self.attribute_map = {
            'approver_comment': 'approverComment'
        }

        self._approver_comment = None

    @property
    def approver_comment(self):
        """
        Gets the approver_comment of this RejectAccessRequestDetails.
        Comment by the approver explaining why the request is rejected.


        :return: The approver_comment of this RejectAccessRequestDetails.
        :rtype: str
        """
        return self._approver_comment

    @approver_comment.setter
    def approver_comment(self, approver_comment):
        """
        Sets the approver_comment of this RejectAccessRequestDetails.
        Comment by the approver explaining why the request is rejected.


        :param approver_comment: The approver_comment of this RejectAccessRequestDetails.
        :type: str
        """
        self._approver_comment = approver_comment

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
