# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostPortScanResultOpenPort(object):
    """
    An open port found in a host port scan
    """

    #: A constant which can be used with the severity property of a HostPortScanResultOpenPort.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a HostPortScanResultOpenPort.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a HostPortScanResultOpenPort.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a HostPortScanResultOpenPort.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a HostPortScanResultOpenPort.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new HostPortScanResultOpenPort object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param port:
            The value to assign to the port property of this HostPortScanResultOpenPort.
        :type port: int

        :param protocol:
            The value to assign to the protocol property of this HostPortScanResultOpenPort.
        :type protocol: str

        :param ip_address:
            The value to assign to the ip_address property of this HostPortScanResultOpenPort.
        :type ip_address: str

        :param vnic_id:
            The value to assign to the vnic_id property of this HostPortScanResultOpenPort.
        :type vnic_id: str

        :param service:
            The value to assign to the service property of this HostPortScanResultOpenPort.
        :type service: str

        :param severity:
            The value to assign to the severity property of this HostPortScanResultOpenPort.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        """
        self.swagger_types = {
            'port': 'int',
            'protocol': 'str',
            'ip_address': 'str',
            'vnic_id': 'str',
            'service': 'str',
            'severity': 'str'
        }

        self.attribute_map = {
            'port': 'port',
            'protocol': 'protocol',
            'ip_address': 'ipAddress',
            'vnic_id': 'vnicId',
            'service': 'service',
            'severity': 'severity'
        }

        self._port = None
        self._protocol = None
        self._ip_address = None
        self._vnic_id = None
        self._service = None
        self._severity = None

    @property
    def port(self):
        """
        **[Required]** Gets the port of this HostPortScanResultOpenPort.
        Open port


        :return: The port of this HostPortScanResultOpenPort.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this HostPortScanResultOpenPort.
        Open port


        :param port: The port of this HostPortScanResultOpenPort.
        :type: int
        """
        self._port = port

    @property
    def protocol(self):
        """
        **[Required]** Gets the protocol of this HostPortScanResultOpenPort.
        Protocol of the open port


        :return: The protocol of this HostPortScanResultOpenPort.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """
        Sets the protocol of this HostPortScanResultOpenPort.
        Protocol of the open port


        :param protocol: The protocol of this HostPortScanResultOpenPort.
        :type: str
        """
        self._protocol = protocol

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this HostPortScanResultOpenPort.
        IP Address open port was found on


        :return: The ip_address of this HostPortScanResultOpenPort.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this HostPortScanResultOpenPort.
        IP Address open port was found on


        :param ip_address: The ip_address of this HostPortScanResultOpenPort.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def vnic_id(self):
        """
        **[Required]** Gets the vnic_id of this HostPortScanResultOpenPort.
        ID of the attached VNIC that exposed the IP Address scanned


        :return: The vnic_id of this HostPortScanResultOpenPort.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this HostPortScanResultOpenPort.
        ID of the attached VNIC that exposed the IP Address scanned


        :param vnic_id: The vnic_id of this HostPortScanResultOpenPort.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def service(self):
        """
        Gets the service of this HostPortScanResultOpenPort.
        Service running on the port (if detected)


        :return: The service of this HostPortScanResultOpenPort.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this HostPortScanResultOpenPort.
        Service running on the port (if detected)


        :param service: The service of this HostPortScanResultOpenPort.
        :type: str
        """
        self._service = service

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this HostPortScanResultOpenPort.
        Problem severity

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this HostPortScanResultOpenPort.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this HostPortScanResultOpenPort.
        Problem severity


        :param severity: The severity of this HostPortScanResultOpenPort.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
