# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityImpactedHostSummary(object):
    """
    Information on a host impacted by a vulnerability
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityImpactedHostSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this VulnerabilityImpactedHostSummary.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VulnerabilityImpactedHostSummary.
        :type compartment_id: str

        :param last_agent_scan_id:
            The value to assign to the last_agent_scan_id property of this VulnerabilityImpactedHostSummary.
        :type last_agent_scan_id: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'compartment_id': 'str',
            'last_agent_scan_id': 'str'
        }

        self.attribute_map = {
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'last_agent_scan_id': 'lastAgentScanId'
        }

        self._instance_id = None
        self._compartment_id = None
        self._last_agent_scan_id = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this VulnerabilityImpactedHostSummary.
        The compute instance ID of the impacted host


        :return: The instance_id of this VulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this VulnerabilityImpactedHostSummary.
        The compute instance ID of the impacted host


        :param instance_id: The instance_id of this VulnerabilityImpactedHostSummary.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VulnerabilityImpactedHostSummary.
        The compartment ID of the impacted host


        :return: The compartment_id of this VulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VulnerabilityImpactedHostSummary.
        The compartment ID of the impacted host


        :param compartment_id: The compartment_id of this VulnerabilityImpactedHostSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def last_agent_scan_id(self):
        """
        **[Required]** Gets the last_agent_scan_id of this VulnerabilityImpactedHostSummary.
        The `OCID`__ of the host agent scan result. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The last_agent_scan_id of this VulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._last_agent_scan_id

    @last_agent_scan_id.setter
    def last_agent_scan_id(self, last_agent_scan_id):
        """
        Sets the last_agent_scan_id of this VulnerabilityImpactedHostSummary.
        The `OCID`__ of the host agent scan result. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param last_agent_scan_id: The last_agent_scan_id of this VulnerabilityImpactedHostSummary.
        :type: str
        """
        self._last_agent_scan_id = last_agent_scan_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
