# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemediationRecipe(object):
    """
    An Application Dependency Management (ADM) remediation recipe contains the basic configuration and the
    details of each of the remediation stages (Detect, Recommend, Verify, and Apply).
    """

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a RemediationRecipe.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new RemediationRecipe object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RemediationRecipe.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this RemediationRecipe.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this RemediationRecipe.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this RemediationRecipe.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this RemediationRecipe.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "INACTIVE", "FAILED", "DELETING", "DELETED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RemediationRecipe.
        :type compartment_id: str

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this RemediationRecipe.
        :type knowledge_base_id: str

        :param is_run_triggered_on_kb_change:
            The value to assign to the is_run_triggered_on_kb_change property of this RemediationRecipe.
        :type is_run_triggered_on_kb_change: bool

        :param scm_configuration:
            The value to assign to the scm_configuration property of this RemediationRecipe.
        :type scm_configuration: oci.adm.models.ScmConfiguration

        :param verify_configuration:
            The value to assign to the verify_configuration property of this RemediationRecipe.
        :type verify_configuration: oci.adm.models.VerifyConfiguration

        :param detect_configuration:
            The value to assign to the detect_configuration property of this RemediationRecipe.
        :type detect_configuration: oci.adm.models.DetectConfiguration

        :param network_configuration:
            The value to assign to the network_configuration property of this RemediationRecipe.
        :type network_configuration: oci.adm.models.NetworkConfiguration

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RemediationRecipe.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RemediationRecipe.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this RemediationRecipe.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'compartment_id': 'str',
            'knowledge_base_id': 'str',
            'is_run_triggered_on_kb_change': 'bool',
            'scm_configuration': 'ScmConfiguration',
            'verify_configuration': 'VerifyConfiguration',
            'detect_configuration': 'DetectConfiguration',
            'network_configuration': 'NetworkConfiguration',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'compartment_id': 'compartmentId',
            'knowledge_base_id': 'knowledgeBaseId',
            'is_run_triggered_on_kb_change': 'isRunTriggeredOnKbChange',
            'scm_configuration': 'scmConfiguration',
            'verify_configuration': 'verifyConfiguration',
            'detect_configuration': 'detectConfiguration',
            'network_configuration': 'networkConfiguration',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._compartment_id = None
        self._knowledge_base_id = None
        self._is_run_triggered_on_kb_change = None
        self._scm_configuration = None
        self._verify_configuration = None
        self._detect_configuration = None
        self._network_configuration = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RemediationRecipe.
        The Oracle Cloud Identifier (`OCID`__) of the remediation recipe.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this RemediationRecipe.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RemediationRecipe.
        The Oracle Cloud Identifier (`OCID`__) of the remediation recipe.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this RemediationRecipe.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this RemediationRecipe.
        The name of the Remediation Recipe.


        :return: The display_name of this RemediationRecipe.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this RemediationRecipe.
        The name of the Remediation Recipe.


        :param display_name: The display_name of this RemediationRecipe.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this RemediationRecipe.
        The creation date and time of the Remediation Recipe (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this RemediationRecipe.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this RemediationRecipe.
        The creation date and time of the Remediation Recipe (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this RemediationRecipe.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this RemediationRecipe.
        The date and time the Remediation Recipe was last updated (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this RemediationRecipe.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this RemediationRecipe.
        The date and time the Remediation Recipe was last updated (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this RemediationRecipe.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this RemediationRecipe.
        The current lifecycle state of the Remediation Recipe.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "INACTIVE", "FAILED", "DELETING", "DELETED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this RemediationRecipe.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this RemediationRecipe.
        The current lifecycle state of the Remediation Recipe.


        :param lifecycle_state: The lifecycle_state of this RemediationRecipe.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "INACTIVE", "FAILED", "DELETING", "DELETED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RemediationRecipe.
        The compartment Oracle Cloud Identifier (`OCID`__) of the remediation recipe.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this RemediationRecipe.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RemediationRecipe.
        The compartment Oracle Cloud Identifier (`OCID`__) of the remediation recipe.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this RemediationRecipe.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this RemediationRecipe.
        The Oracle Cloud Identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this RemediationRecipe.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this RemediationRecipe.
        The Oracle Cloud Identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this RemediationRecipe.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def is_run_triggered_on_kb_change(self):
        """
        **[Required]** Gets the is_run_triggered_on_kb_change of this RemediationRecipe.
        Boolean indicating if a run should be automatically triggered once the Knowledge Base contents are updated.


        :return: The is_run_triggered_on_kb_change of this RemediationRecipe.
        :rtype: bool
        """
        return self._is_run_triggered_on_kb_change

    @is_run_triggered_on_kb_change.setter
    def is_run_triggered_on_kb_change(self, is_run_triggered_on_kb_change):
        """
        Sets the is_run_triggered_on_kb_change of this RemediationRecipe.
        Boolean indicating if a run should be automatically triggered once the Knowledge Base contents are updated.


        :param is_run_triggered_on_kb_change: The is_run_triggered_on_kb_change of this RemediationRecipe.
        :type: bool
        """
        self._is_run_triggered_on_kb_change = is_run_triggered_on_kb_change

    @property
    def scm_configuration(self):
        """
        **[Required]** Gets the scm_configuration of this RemediationRecipe.

        :return: The scm_configuration of this RemediationRecipe.
        :rtype: oci.adm.models.ScmConfiguration
        """
        return self._scm_configuration

    @scm_configuration.setter
    def scm_configuration(self, scm_configuration):
        """
        Sets the scm_configuration of this RemediationRecipe.

        :param scm_configuration: The scm_configuration of this RemediationRecipe.
        :type: oci.adm.models.ScmConfiguration
        """
        self._scm_configuration = scm_configuration

    @property
    def verify_configuration(self):
        """
        **[Required]** Gets the verify_configuration of this RemediationRecipe.

        :return: The verify_configuration of this RemediationRecipe.
        :rtype: oci.adm.models.VerifyConfiguration
        """
        return self._verify_configuration

    @verify_configuration.setter
    def verify_configuration(self, verify_configuration):
        """
        Sets the verify_configuration of this RemediationRecipe.

        :param verify_configuration: The verify_configuration of this RemediationRecipe.
        :type: oci.adm.models.VerifyConfiguration
        """
        self._verify_configuration = verify_configuration

    @property
    def detect_configuration(self):
        """
        **[Required]** Gets the detect_configuration of this RemediationRecipe.

        :return: The detect_configuration of this RemediationRecipe.
        :rtype: oci.adm.models.DetectConfiguration
        """
        return self._detect_configuration

    @detect_configuration.setter
    def detect_configuration(self, detect_configuration):
        """
        Sets the detect_configuration of this RemediationRecipe.

        :param detect_configuration: The detect_configuration of this RemediationRecipe.
        :type: oci.adm.models.DetectConfiguration
        """
        self._detect_configuration = detect_configuration

    @property
    def network_configuration(self):
        """
        **[Required]** Gets the network_configuration of this RemediationRecipe.

        :return: The network_configuration of this RemediationRecipe.
        :rtype: oci.adm.models.NetworkConfiguration
        """
        return self._network_configuration

    @network_configuration.setter
    def network_configuration(self, network_configuration):
        """
        Sets the network_configuration of this RemediationRecipe.

        :param network_configuration: The network_configuration of this RemediationRecipe.
        :type: oci.adm.models.NetworkConfiguration
        """
        self._network_configuration = network_configuration

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this RemediationRecipe.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this RemediationRecipe.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RemediationRecipe.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this RemediationRecipe.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this RemediationRecipe.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this RemediationRecipe.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RemediationRecipe.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this RemediationRecipe.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this RemediationRecipe.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this RemediationRecipe.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this RemediationRecipe.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this RemediationRecipe.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
