# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityAuditSummary(object):
    """
    vulnerability audit summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityAuditSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VulnerabilityAuditSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this VulnerabilityAuditSummary.
        :type display_name: str

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this VulnerabilityAuditSummary.
        :type knowledge_base_id: str

        :param time_created:
            The value to assign to the time_created property of this VulnerabilityAuditSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this VulnerabilityAuditSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VulnerabilityAuditSummary.
        :type lifecycle_state: str

        :param max_observed_cvss_v2_score:
            The value to assign to the max_observed_cvss_v2_score property of this VulnerabilityAuditSummary.
        :type max_observed_cvss_v2_score: float

        :param max_observed_cvss_v3_score:
            The value to assign to the max_observed_cvss_v3_score property of this VulnerabilityAuditSummary.
        :type max_observed_cvss_v3_score: float

        :param vulnerable_artifacts_count:
            The value to assign to the vulnerable_artifacts_count property of this VulnerabilityAuditSummary.
        :type vulnerable_artifacts_count: int

        :param max_observed_cvss_v2_score_with_ignored:
            The value to assign to the max_observed_cvss_v2_score_with_ignored property of this VulnerabilityAuditSummary.
        :type max_observed_cvss_v2_score_with_ignored: float

        :param max_observed_cvss_v3_score_with_ignored:
            The value to assign to the max_observed_cvss_v3_score_with_ignored property of this VulnerabilityAuditSummary.
        :type max_observed_cvss_v3_score_with_ignored: float

        :param vulnerable_artifacts_count_with_ignored:
            The value to assign to the vulnerable_artifacts_count_with_ignored property of this VulnerabilityAuditSummary.
        :type vulnerable_artifacts_count_with_ignored: int

        :param is_success:
            The value to assign to the is_success property of this VulnerabilityAuditSummary.
        :type is_success: bool

        :param build_type:
            The value to assign to the build_type property of this VulnerabilityAuditSummary.
        :type build_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VulnerabilityAuditSummary.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this VulnerabilityAuditSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this VulnerabilityAuditSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this VulnerabilityAuditSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'knowledge_base_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'max_observed_cvss_v2_score': 'float',
            'max_observed_cvss_v3_score': 'float',
            'vulnerable_artifacts_count': 'int',
            'max_observed_cvss_v2_score_with_ignored': 'float',
            'max_observed_cvss_v3_score_with_ignored': 'float',
            'vulnerable_artifacts_count_with_ignored': 'int',
            'is_success': 'bool',
            'build_type': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'knowledge_base_id': 'knowledgeBaseId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'max_observed_cvss_v2_score': 'maxObservedCvssV2Score',
            'max_observed_cvss_v3_score': 'maxObservedCvssV3Score',
            'vulnerable_artifacts_count': 'vulnerableArtifactsCount',
            'max_observed_cvss_v2_score_with_ignored': 'maxObservedCvssV2ScoreWithIgnored',
            'max_observed_cvss_v3_score_with_ignored': 'maxObservedCvssV3ScoreWithIgnored',
            'vulnerable_artifacts_count_with_ignored': 'vulnerableArtifactsCountWithIgnored',
            'is_success': 'isSuccess',
            'build_type': 'buildType',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._knowledge_base_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._max_observed_cvss_v2_score = None
        self._max_observed_cvss_v3_score = None
        self._vulnerable_artifacts_count = None
        self._max_observed_cvss_v2_score_with_ignored = None
        self._max_observed_cvss_v3_score_with_ignored = None
        self._vulnerable_artifacts_count_with_ignored = None
        self._is_success = None
        self._build_type = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this VulnerabilityAuditSummary.
        The Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VulnerabilityAuditSummary.
        The Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this VulnerabilityAuditSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this VulnerabilityAuditSummary.
        The name of the vulnerability audit.


        :return: The display_name of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this VulnerabilityAuditSummary.
        The name of the vulnerability audit.


        :param display_name: The display_name of this VulnerabilityAuditSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this VulnerabilityAuditSummary.
        The Oracle Cloud identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this VulnerabilityAuditSummary.
        The Oracle Cloud identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this VulnerabilityAuditSummary.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this VulnerabilityAuditSummary.
        The creation date and time of the vulnerability audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this VulnerabilityAuditSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this VulnerabilityAuditSummary.
        The creation date and time of the vulnerability audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this VulnerabilityAuditSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this VulnerabilityAuditSummary.
        The update date and time of the vulnerability audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this VulnerabilityAuditSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this VulnerabilityAuditSummary.
        The update date and time of the vulnerability audit (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this VulnerabilityAuditSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this VulnerabilityAuditSummary.
        The current lifecycle state of the vulnerability audit.


        :return: The lifecycle_state of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this VulnerabilityAuditSummary.
        The current lifecycle state of the vulnerability audit.


        :param lifecycle_state: The lifecycle_state of this VulnerabilityAuditSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def max_observed_cvss_v2_score(self):
        """
        **[Required]** Gets the max_observed_cvss_v2_score of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.


        :return: The max_observed_cvss_v2_score of this VulnerabilityAuditSummary.
        :rtype: float
        """
        return self._max_observed_cvss_v2_score

    @max_observed_cvss_v2_score.setter
    def max_observed_cvss_v2_score(self, max_observed_cvss_v2_score):
        """
        Sets the max_observed_cvss_v2_score of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.


        :param max_observed_cvss_v2_score: The max_observed_cvss_v2_score of this VulnerabilityAuditSummary.
        :type: float
        """
        self._max_observed_cvss_v2_score = max_observed_cvss_v2_score

    @property
    def max_observed_cvss_v3_score(self):
        """
        **[Required]** Gets the max_observed_cvss_v3_score of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.


        :return: The max_observed_cvss_v3_score of this VulnerabilityAuditSummary.
        :rtype: float
        """
        return self._max_observed_cvss_v3_score

    @max_observed_cvss_v3_score.setter
    def max_observed_cvss_v3_score(self, max_observed_cvss_v3_score):
        """
        Sets the max_observed_cvss_v3_score of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.


        :param max_observed_cvss_v3_score: The max_observed_cvss_v3_score of this VulnerabilityAuditSummary.
        :type: float
        """
        self._max_observed_cvss_v3_score = max_observed_cvss_v3_score

    @property
    def vulnerable_artifacts_count(self):
        """
        **[Required]** Gets the vulnerable_artifacts_count of this VulnerabilityAuditSummary.
        Count of non-ignored vulnerable application dependencies.


        :return: The vulnerable_artifacts_count of this VulnerabilityAuditSummary.
        :rtype: int
        """
        return self._vulnerable_artifacts_count

    @vulnerable_artifacts_count.setter
    def vulnerable_artifacts_count(self, vulnerable_artifacts_count):
        """
        Sets the vulnerable_artifacts_count of this VulnerabilityAuditSummary.
        Count of non-ignored vulnerable application dependencies.


        :param vulnerable_artifacts_count: The vulnerable_artifacts_count of this VulnerabilityAuditSummary.
        :type: int
        """
        self._vulnerable_artifacts_count = vulnerable_artifacts_count

    @property
    def max_observed_cvss_v2_score_with_ignored(self):
        """
        **[Required]** Gets the max_observed_cvss_v2_score_with_ignored of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.


        :return: The max_observed_cvss_v2_score_with_ignored of this VulnerabilityAuditSummary.
        :rtype: float
        """
        return self._max_observed_cvss_v2_score_with_ignored

    @max_observed_cvss_v2_score_with_ignored.setter
    def max_observed_cvss_v2_score_with_ignored(self, max_observed_cvss_v2_score_with_ignored):
        """
        Sets the max_observed_cvss_v2_score_with_ignored of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.


        :param max_observed_cvss_v2_score_with_ignored: The max_observed_cvss_v2_score_with_ignored of this VulnerabilityAuditSummary.
        :type: float
        """
        self._max_observed_cvss_v2_score_with_ignored = max_observed_cvss_v2_score_with_ignored

    @property
    def max_observed_cvss_v3_score_with_ignored(self):
        """
        **[Required]** Gets the max_observed_cvss_v3_score_with_ignored of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.


        :return: The max_observed_cvss_v3_score_with_ignored of this VulnerabilityAuditSummary.
        :rtype: float
        """
        return self._max_observed_cvss_v3_score_with_ignored

    @max_observed_cvss_v3_score_with_ignored.setter
    def max_observed_cvss_v3_score_with_ignored(self, max_observed_cvss_v3_score_with_ignored):
        """
        Sets the max_observed_cvss_v3_score_with_ignored of this VulnerabilityAuditSummary.
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.


        :param max_observed_cvss_v3_score_with_ignored: The max_observed_cvss_v3_score_with_ignored of this VulnerabilityAuditSummary.
        :type: float
        """
        self._max_observed_cvss_v3_score_with_ignored = max_observed_cvss_v3_score_with_ignored

    @property
    def vulnerable_artifacts_count_with_ignored(self):
        """
        **[Required]** Gets the vulnerable_artifacts_count_with_ignored of this VulnerabilityAuditSummary.
        Count of all vulnerable application dependencies.


        :return: The vulnerable_artifacts_count_with_ignored of this VulnerabilityAuditSummary.
        :rtype: int
        """
        return self._vulnerable_artifacts_count_with_ignored

    @vulnerable_artifacts_count_with_ignored.setter
    def vulnerable_artifacts_count_with_ignored(self, vulnerable_artifacts_count_with_ignored):
        """
        Sets the vulnerable_artifacts_count_with_ignored of this VulnerabilityAuditSummary.
        Count of all vulnerable application dependencies.


        :param vulnerable_artifacts_count_with_ignored: The vulnerable_artifacts_count_with_ignored of this VulnerabilityAuditSummary.
        :type: int
        """
        self._vulnerable_artifacts_count_with_ignored = vulnerable_artifacts_count_with_ignored

    @property
    def is_success(self):
        """
        Gets the is_success of this VulnerabilityAuditSummary.
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.


        :return: The is_success of this VulnerabilityAuditSummary.
        :rtype: bool
        """
        return self._is_success

    @is_success.setter
    def is_success(self, is_success):
        """
        Sets the is_success of this VulnerabilityAuditSummary.
        Indicates if an audit succeeded according to the configuration. The value is `null` if the audit is in the `CREATING` state.


        :param is_success: The is_success of this VulnerabilityAuditSummary.
        :type: bool
        """
        self._is_success = is_success

    @property
    def build_type(self):
        """
        Gets the build_type of this VulnerabilityAuditSummary.
        Type of the build tool.


        :return: The build_type of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._build_type

    @build_type.setter
    def build_type(self, build_type):
        """
        Sets the build_type of this VulnerabilityAuditSummary.
        Type of the build tool.


        :param build_type: The build_type of this VulnerabilityAuditSummary.
        :type: str
        """
        self._build_type = build_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VulnerabilityAuditSummary.
        The compartment Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this VulnerabilityAuditSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VulnerabilityAuditSummary.
        The compartment Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this VulnerabilityAuditSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this VulnerabilityAuditSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this VulnerabilityAuditSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this VulnerabilityAuditSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this VulnerabilityAuditSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this VulnerabilityAuditSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this VulnerabilityAuditSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this VulnerabilityAuditSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this VulnerabilityAuditSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this VulnerabilityAuditSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this VulnerabilityAuditSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this VulnerabilityAuditSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this VulnerabilityAuditSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
