# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateInstancePoolDetails(object):
    """
    The data to create an instance pool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateInstancePoolDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateInstancePoolDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateInstancePoolDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreateInstancePoolDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateInstancePoolDetails.
        :type freeform_tags: dict(str, str)

        :param instance_configuration_id:
            The value to assign to the instance_configuration_id property of this CreateInstancePoolDetails.
        :type instance_configuration_id: str

        :param placement_configurations:
            The value to assign to the placement_configurations property of this CreateInstancePoolDetails.
        :type placement_configurations: list[oci.core.models.CreateInstancePoolPlacementConfigurationDetails]

        :param size:
            The value to assign to the size property of this CreateInstancePoolDetails.
        :type size: int

        :param load_balancers:
            The value to assign to the load_balancers property of this CreateInstancePoolDetails.
        :type load_balancers: list[oci.core.models.AttachLoadBalancerDetails]

        :param instance_display_name_formatter:
            The value to assign to the instance_display_name_formatter property of this CreateInstancePoolDetails.
        :type instance_display_name_formatter: str

        :param instance_hostname_formatter:
            The value to assign to the instance_hostname_formatter property of this CreateInstancePoolDetails.
        :type instance_hostname_formatter: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'instance_configuration_id': 'str',
            'placement_configurations': 'list[CreateInstancePoolPlacementConfigurationDetails]',
            'size': 'int',
            'load_balancers': 'list[AttachLoadBalancerDetails]',
            'instance_display_name_formatter': 'str',
            'instance_hostname_formatter': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'instance_configuration_id': 'instanceConfigurationId',
            'placement_configurations': 'placementConfigurations',
            'size': 'size',
            'load_balancers': 'loadBalancers',
            'instance_display_name_formatter': 'instanceDisplayNameFormatter',
            'instance_hostname_formatter': 'instanceHostnameFormatter'
        }

        self._compartment_id = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._instance_configuration_id = None
        self._placement_configurations = None
        self._size = None
        self._load_balancers = None
        self._instance_display_name_formatter = None
        self._instance_hostname_formatter = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateInstancePoolDetails.
        The `OCID`__ of the compartment containing the instance pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateInstancePoolDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateInstancePoolDetails.
        The `OCID`__ of the compartment containing the instance pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateInstancePoolDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateInstancePoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateInstancePoolDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateInstancePoolDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateInstancePoolDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateInstancePoolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateInstancePoolDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateInstancePoolDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateInstancePoolDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateInstancePoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateInstancePoolDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateInstancePoolDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateInstancePoolDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def instance_configuration_id(self):
        """
        **[Required]** Gets the instance_configuration_id of this CreateInstancePoolDetails.
        The `OCID`__ of the instance configuration associated
        with the instance pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The instance_configuration_id of this CreateInstancePoolDetails.
        :rtype: str
        """
        return self._instance_configuration_id

    @instance_configuration_id.setter
    def instance_configuration_id(self, instance_configuration_id):
        """
        Sets the instance_configuration_id of this CreateInstancePoolDetails.
        The `OCID`__ of the instance configuration associated
        with the instance pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param instance_configuration_id: The instance_configuration_id of this CreateInstancePoolDetails.
        :type: str
        """
        self._instance_configuration_id = instance_configuration_id

    @property
    def placement_configurations(self):
        """
        **[Required]** Gets the placement_configurations of this CreateInstancePoolDetails.
        The placement configurations for the instance pool. Provide one placement configuration for
        each availability domain.

        To use the instance pool with a regional subnet, provide a placement configuration for
        each availability domain, and include the regional subnet in each placement
        configuration.


        :return: The placement_configurations of this CreateInstancePoolDetails.
        :rtype: list[oci.core.models.CreateInstancePoolPlacementConfigurationDetails]
        """
        return self._placement_configurations

    @placement_configurations.setter
    def placement_configurations(self, placement_configurations):
        """
        Sets the placement_configurations of this CreateInstancePoolDetails.
        The placement configurations for the instance pool. Provide one placement configuration for
        each availability domain.

        To use the instance pool with a regional subnet, provide a placement configuration for
        each availability domain, and include the regional subnet in each placement
        configuration.


        :param placement_configurations: The placement_configurations of this CreateInstancePoolDetails.
        :type: list[oci.core.models.CreateInstancePoolPlacementConfigurationDetails]
        """
        self._placement_configurations = placement_configurations

    @property
    def size(self):
        """
        **[Required]** Gets the size of this CreateInstancePoolDetails.
        The number of instances that should be in the instance pool.


        :return: The size of this CreateInstancePoolDetails.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this CreateInstancePoolDetails.
        The number of instances that should be in the instance pool.


        :param size: The size of this CreateInstancePoolDetails.
        :type: int
        """
        self._size = size

    @property
    def load_balancers(self):
        """
        Gets the load_balancers of this CreateInstancePoolDetails.
        The load balancers to attach to the instance pool.


        :return: The load_balancers of this CreateInstancePoolDetails.
        :rtype: list[oci.core.models.AttachLoadBalancerDetails]
        """
        return self._load_balancers

    @load_balancers.setter
    def load_balancers(self, load_balancers):
        """
        Sets the load_balancers of this CreateInstancePoolDetails.
        The load balancers to attach to the instance pool.


        :param load_balancers: The load_balancers of this CreateInstancePoolDetails.
        :type: list[oci.core.models.AttachLoadBalancerDetails]
        """
        self._load_balancers = load_balancers

    @property
    def instance_display_name_formatter(self):
        """
        Gets the instance_display_name_formatter of this CreateInstancePoolDetails.
        A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format.
        The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format


        :return: The instance_display_name_formatter of this CreateInstancePoolDetails.
        :rtype: str
        """
        return self._instance_display_name_formatter

    @instance_display_name_formatter.setter
    def instance_display_name_formatter(self, instance_display_name_formatter):
        """
        Sets the instance_display_name_formatter of this CreateInstancePoolDetails.
        A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format.
        The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format


        :param instance_display_name_formatter: The instance_display_name_formatter of this CreateInstancePoolDetails.
        :type: str
        """
        self._instance_display_name_formatter = instance_display_name_formatter

    @property
    def instance_hostname_formatter(self):
        """
        Gets the instance_hostname_formatter of this CreateInstancePoolDetails.
        A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format.
        The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format


        :return: The instance_hostname_formatter of this CreateInstancePoolDetails.
        :rtype: str
        """
        return self._instance_hostname_formatter

    @instance_hostname_formatter.setter
    def instance_hostname_formatter(self, instance_hostname_formatter):
        """
        Sets the instance_hostname_formatter of this CreateInstancePoolDetails.
        A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format.
        The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format


        :param instance_hostname_formatter: The instance_hostname_formatter of this CreateInstancePoolDetails.
        :type: str
        """
        self._instance_hostname_formatter = instance_hostname_formatter

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
