# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportRequest(object):
    """
    Export metadata object response.
    """

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "SUCCESSFUL"
    STATUS_SUCCESSFUL = "SUCCESSFUL"

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "TERMINATING"
    STATUS_TERMINATING = "TERMINATING"

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "TERMINATED"
    STATUS_TERMINATED = "TERMINATED"

    #: A constant which can be used with the status property of a ExportRequest.
    #: This constant has a value of "QUEUED"
    STATUS_QUEUED = "QUEUED"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this ExportRequest.
        :type key: str

        :param object_keys:
            The value to assign to the object_keys property of this ExportRequest.
        :type object_keys: list[str]

        :param bucket_name:
            The value to assign to the bucket_name property of this ExportRequest.
        :type bucket_name: str

        :param file_name:
            The value to assign to the file_name property of this ExportRequest.
        :type file_name: str

        :param object_storage_tenancy_id:
            The value to assign to the object_storage_tenancy_id property of this ExportRequest.
        :type object_storage_tenancy_id: str

        :param object_storage_region:
            The value to assign to the object_storage_region property of this ExportRequest.
        :type object_storage_region: str

        :param are_references_included:
            The value to assign to the are_references_included property of this ExportRequest.
        :type are_references_included: bool

        :param is_object_overwrite_enabled:
            The value to assign to the is_object_overwrite_enabled property of this ExportRequest.
        :type is_object_overwrite_enabled: bool

        :param filters:
            The value to assign to the filters property of this ExportRequest.
        :type filters: list[str]

        :param status:
            The value to assign to the status property of this ExportRequest.
            Allowed values for this property are: "SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param created_by:
            The value to assign to the created_by property of this ExportRequest.
        :type created_by: str

        :param total_exported_object_count:
            The value to assign to the total_exported_object_count property of this ExportRequest.
        :type total_exported_object_count: int

        :param time_started_in_millis:
            The value to assign to the time_started_in_millis property of this ExportRequest.
        :type time_started_in_millis: int

        :param time_ended_in_millis:
            The value to assign to the time_ended_in_millis property of this ExportRequest.
        :type time_ended_in_millis: int

        :param error_messages:
            The value to assign to the error_messages property of this ExportRequest.
        :type error_messages: dict(str, str)

        :param exported_items:
            The value to assign to the exported_items property of this ExportRequest.
        :type exported_items: list[oci.data_integration.models.ExportObjectMetadataSummary]

        :param referenced_items:
            The value to assign to the referenced_items property of this ExportRequest.
        :type referenced_items: str

        :param name:
            The value to assign to the name property of this ExportRequest.
        :type name: str

        """
        self.swagger_types = {
            'key': 'str',
            'object_keys': 'list[str]',
            'bucket_name': 'str',
            'file_name': 'str',
            'object_storage_tenancy_id': 'str',
            'object_storage_region': 'str',
            'are_references_included': 'bool',
            'is_object_overwrite_enabled': 'bool',
            'filters': 'list[str]',
            'status': 'str',
            'created_by': 'str',
            'total_exported_object_count': 'int',
            'time_started_in_millis': 'int',
            'time_ended_in_millis': 'int',
            'error_messages': 'dict(str, str)',
            'exported_items': 'list[ExportObjectMetadataSummary]',
            'referenced_items': 'str',
            'name': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'object_keys': 'objectKeys',
            'bucket_name': 'bucketName',
            'file_name': 'fileName',
            'object_storage_tenancy_id': 'objectStorageTenancyId',
            'object_storage_region': 'objectStorageRegion',
            'are_references_included': 'areReferencesIncluded',
            'is_object_overwrite_enabled': 'isObjectOverwriteEnabled',
            'filters': 'filters',
            'status': 'status',
            'created_by': 'createdBy',
            'total_exported_object_count': 'totalExportedObjectCount',
            'time_started_in_millis': 'timeStartedInMillis',
            'time_ended_in_millis': 'timeEndedInMillis',
            'error_messages': 'errorMessages',
            'exported_items': 'exportedItems',
            'referenced_items': 'referencedItems',
            'name': 'name'
        }

        self._key = None
        self._object_keys = None
        self._bucket_name = None
        self._file_name = None
        self._object_storage_tenancy_id = None
        self._object_storage_region = None
        self._are_references_included = None
        self._is_object_overwrite_enabled = None
        self._filters = None
        self._status = None
        self._created_by = None
        self._total_exported_object_count = None
        self._time_started_in_millis = None
        self._time_ended_in_millis = None
        self._error_messages = None
        self._exported_items = None
        self._referenced_items = None
        self._name = None

    @property
    def key(self):
        """
        Gets the key of this ExportRequest.
        Export object request key


        :return: The key of this ExportRequest.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ExportRequest.
        Export object request key


        :param key: The key of this ExportRequest.
        :type: str
        """
        self._key = key

    @property
    def object_keys(self):
        """
        Gets the object_keys of this ExportRequest.
        The list of the objects to be exported


        :return: The object_keys of this ExportRequest.
        :rtype: list[str]
        """
        return self._object_keys

    @object_keys.setter
    def object_keys(self, object_keys):
        """
        Sets the object_keys of this ExportRequest.
        The list of the objects to be exported


        :param object_keys: The object_keys of this ExportRequest.
        :type: list[str]
        """
        self._object_keys = object_keys

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this ExportRequest.
        The name of the Object Storage Bucket where the objects will be exported to


        :return: The bucket_name of this ExportRequest.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ExportRequest.
        The name of the Object Storage Bucket where the objects will be exported to


        :param bucket_name: The bucket_name of this ExportRequest.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def file_name(self):
        """
        Gets the file_name of this ExportRequest.
        Name of the exported zip file.


        :return: The file_name of this ExportRequest.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this ExportRequest.
        Name of the exported zip file.


        :param file_name: The file_name of this ExportRequest.
        :type: str
        """
        self._file_name = file_name

    @property
    def object_storage_tenancy_id(self):
        """
        Gets the object_storage_tenancy_id of this ExportRequest.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :return: The object_storage_tenancy_id of this ExportRequest.
        :rtype: str
        """
        return self._object_storage_tenancy_id

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, object_storage_tenancy_id):
        """
        Sets the object_storage_tenancy_id of this ExportRequest.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :param object_storage_tenancy_id: The object_storage_tenancy_id of this ExportRequest.
        :type: str
        """
        self._object_storage_tenancy_id = object_storage_tenancy_id

    @property
    def object_storage_region(self):
        """
        Gets the object_storage_region of this ExportRequest.
        Region of the object storage (if using object storage of different region)


        :return: The object_storage_region of this ExportRequest.
        :rtype: str
        """
        return self._object_storage_region

    @object_storage_region.setter
    def object_storage_region(self, object_storage_region):
        """
        Sets the object_storage_region of this ExportRequest.
        Region of the object storage (if using object storage of different region)


        :param object_storage_region: The object_storage_region of this ExportRequest.
        :type: str
        """
        self._object_storage_region = object_storage_region

    @property
    def are_references_included(self):
        """
        Gets the are_references_included of this ExportRequest.
        Controls if the references will be exported along with the objects


        :return: The are_references_included of this ExportRequest.
        :rtype: bool
        """
        return self._are_references_included

    @are_references_included.setter
    def are_references_included(self, are_references_included):
        """
        Sets the are_references_included of this ExportRequest.
        Controls if the references will be exported along with the objects


        :param are_references_included: The are_references_included of this ExportRequest.
        :type: bool
        """
        self._are_references_included = are_references_included

    @property
    def is_object_overwrite_enabled(self):
        """
        Gets the is_object_overwrite_enabled of this ExportRequest.
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.


        :return: The is_object_overwrite_enabled of this ExportRequest.
        :rtype: bool
        """
        return self._is_object_overwrite_enabled

    @is_object_overwrite_enabled.setter
    def is_object_overwrite_enabled(self, is_object_overwrite_enabled):
        """
        Sets the is_object_overwrite_enabled of this ExportRequest.
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.


        :param is_object_overwrite_enabled: The is_object_overwrite_enabled of this ExportRequest.
        :type: bool
        """
        self._is_object_overwrite_enabled = is_object_overwrite_enabled

    @property
    def filters(self):
        """
        Gets the filters of this ExportRequest.
        Export multiple objects based on filters.


        :return: The filters of this ExportRequest.
        :rtype: list[str]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this ExportRequest.
        Export multiple objects based on filters.


        :param filters: The filters of this ExportRequest.
        :type: list[str]
        """
        self._filters = filters

    @property
    def status(self):
        """
        Gets the status of this ExportRequest.
        Export Objects request status.

        Allowed values for this property are: "SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ExportRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ExportRequest.
        Export Objects request status.


        :param status: The status of this ExportRequest.
        :type: str
        """
        allowed_values = ["SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def created_by(self):
        """
        Gets the created_by of this ExportRequest.
        Name of the user who initiated export request.


        :return: The created_by of this ExportRequest.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this ExportRequest.
        Name of the user who initiated export request.


        :param created_by: The created_by of this ExportRequest.
        :type: str
        """
        self._created_by = created_by

    @property
    def total_exported_object_count(self):
        """
        Gets the total_exported_object_count of this ExportRequest.
        Number of objects that are exported.


        :return: The total_exported_object_count of this ExportRequest.
        :rtype: int
        """
        return self._total_exported_object_count

    @total_exported_object_count.setter
    def total_exported_object_count(self, total_exported_object_count):
        """
        Sets the total_exported_object_count of this ExportRequest.
        Number of objects that are exported.


        :param total_exported_object_count: The total_exported_object_count of this ExportRequest.
        :type: int
        """
        self._total_exported_object_count = total_exported_object_count

    @property
    def time_started_in_millis(self):
        """
        Gets the time_started_in_millis of this ExportRequest.
        Time at which the request started getting processed.


        :return: The time_started_in_millis of this ExportRequest.
        :rtype: int
        """
        return self._time_started_in_millis

    @time_started_in_millis.setter
    def time_started_in_millis(self, time_started_in_millis):
        """
        Sets the time_started_in_millis of this ExportRequest.
        Time at which the request started getting processed.


        :param time_started_in_millis: The time_started_in_millis of this ExportRequest.
        :type: int
        """
        self._time_started_in_millis = time_started_in_millis

    @property
    def time_ended_in_millis(self):
        """
        Gets the time_ended_in_millis of this ExportRequest.
        Time at which the request was completely processed.


        :return: The time_ended_in_millis of this ExportRequest.
        :rtype: int
        """
        return self._time_ended_in_millis

    @time_ended_in_millis.setter
    def time_ended_in_millis(self, time_ended_in_millis):
        """
        Sets the time_ended_in_millis of this ExportRequest.
        Time at which the request was completely processed.


        :param time_ended_in_millis: The time_ended_in_millis of this ExportRequest.
        :type: int
        """
        self._time_ended_in_millis = time_ended_in_millis

    @property
    def error_messages(self):
        """
        Gets the error_messages of this ExportRequest.
        Contains key of the error


        :return: The error_messages of this ExportRequest.
        :rtype: dict(str, str)
        """
        return self._error_messages

    @error_messages.setter
    def error_messages(self, error_messages):
        """
        Sets the error_messages of this ExportRequest.
        Contains key of the error


        :param error_messages: The error_messages of this ExportRequest.
        :type: dict(str, str)
        """
        self._error_messages = error_messages

    @property
    def exported_items(self):
        """
        Gets the exported_items of this ExportRequest.
        The array of exported object details.


        :return: The exported_items of this ExportRequest.
        :rtype: list[oci.data_integration.models.ExportObjectMetadataSummary]
        """
        return self._exported_items

    @exported_items.setter
    def exported_items(self, exported_items):
        """
        Sets the exported_items of this ExportRequest.
        The array of exported object details.


        :param exported_items: The exported_items of this ExportRequest.
        :type: list[oci.data_integration.models.ExportObjectMetadataSummary]
        """
        self._exported_items = exported_items

    @property
    def referenced_items(self):
        """
        Gets the referenced_items of this ExportRequest.
        The array of exported referenced objects.


        :return: The referenced_items of this ExportRequest.
        :rtype: str
        """
        return self._referenced_items

    @referenced_items.setter
    def referenced_items(self, referenced_items):
        """
        Sets the referenced_items of this ExportRequest.
        The array of exported referenced objects.


        :param referenced_items: The referenced_items of this ExportRequest.
        :type: str
        """
        self._referenced_items = referenced_items

    @property
    def name(self):
        """
        Gets the name of this ExportRequest.
        Name of the export request.


        :return: The name of this ExportRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportRequest.
        Name of the export request.


        :param name: The name of this ExportRequest.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
