# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSqlCollectionDetails(object):
    """
    Details for SQL collection creation.
    """

    #: A constant which can be used with the status property of a CreateSqlCollectionDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a CreateSqlCollectionDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    #: A constant which can be used with the sql_level property of a CreateSqlCollectionDetails.
    #: This constant has a value of "USER_ISSUED_SQL"
    SQL_LEVEL_USER_ISSUED_SQL = "USER_ISSUED_SQL"

    #: A constant which can be used with the sql_level property of a CreateSqlCollectionDetails.
    #: This constant has a value of "ALL_SQL"
    SQL_LEVEL_ALL_SQL = "ALL_SQL"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSqlCollectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateSqlCollectionDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateSqlCollectionDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSqlCollectionDetails.
        :type compartment_id: str

        :param target_id:
            The value to assign to the target_id property of this CreateSqlCollectionDetails.
        :type target_id: str

        :param status:
            The value to assign to the status property of this CreateSqlCollectionDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type status: str

        :param db_user_name:
            The value to assign to the db_user_name property of this CreateSqlCollectionDetails.
        :type db_user_name: str

        :param sql_level:
            The value to assign to the sql_level property of this CreateSqlCollectionDetails.
            Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL"
        :type sql_level: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSqlCollectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSqlCollectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'target_id': 'str',
            'status': 'str',
            'db_user_name': 'str',
            'sql_level': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'target_id': 'targetId',
            'status': 'status',
            'db_user_name': 'dbUserName',
            'sql_level': 'sqlLevel',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._target_id = None
        self._status = None
        self._db_user_name = None
        self._sql_level = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateSqlCollectionDetails.
        The display name of the SQL collection. The name does not have to be unique, and it is changeable.


        :return: The display_name of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateSqlCollectionDetails.
        The display name of the SQL collection. The name does not have to be unique, and it is changeable.


        :param display_name: The display_name of this CreateSqlCollectionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateSqlCollectionDetails.
        The description of the SQL collection.


        :return: The description of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateSqlCollectionDetails.
        The description of the SQL collection.


        :param description: The description of this CreateSqlCollectionDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSqlCollectionDetails.
        The OCID of the compartment containing the SQL collection.


        :return: The compartment_id of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSqlCollectionDetails.
        The OCID of the compartment containing the SQL collection.


        :param compartment_id: The compartment_id of this CreateSqlCollectionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this CreateSqlCollectionDetails.
        The OCID of the target corresponding to the security policy deployment.


        :return: The target_id of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this CreateSqlCollectionDetails.
        The OCID of the target corresponding to the security policy deployment.


        :param target_id: The target_id of this CreateSqlCollectionDetails.
        :type: str
        """
        self._target_id = target_id

    @property
    def status(self):
        """
        Gets the status of this CreateSqlCollectionDetails.
        Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The status of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CreateSqlCollectionDetails.
        Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.


        :param status: The status of this CreateSqlCollectionDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            raise ValueError(
                f"Invalid value for `status`, must be None or one of {allowed_values}"
            )
        self._status = status

    @property
    def db_user_name(self):
        """
        **[Required]** Gets the db_user_name of this CreateSqlCollectionDetails.
        The database user name.


        :return: The db_user_name of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._db_user_name

    @db_user_name.setter
    def db_user_name(self, db_user_name):
        """
        Sets the db_user_name of this CreateSqlCollectionDetails.
        The database user name.


        :param db_user_name: The db_user_name of this CreateSqlCollectionDetails.
        :type: str
        """
        self._db_user_name = db_user_name

    @property
    def sql_level(self):
        """
        Gets the sql_level of this CreateSqlCollectionDetails.
        Specifies the level of SQL that will be collected.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.

        Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL"


        :return: The sql_level of this CreateSqlCollectionDetails.
        :rtype: str
        """
        return self._sql_level

    @sql_level.setter
    def sql_level(self, sql_level):
        """
        Sets the sql_level of this CreateSqlCollectionDetails.
        Specifies the level of SQL that will be collected.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.


        :param sql_level: The sql_level of this CreateSqlCollectionDetails.
        :type: str
        """
        allowed_values = ["USER_ISSUED_SQL", "ALL_SQL"]
        if not value_allowed_none_or_none_sentinel(sql_level, allowed_values):
            raise ValueError(
                f"Invalid value for `sql_level`, must be None or one of {allowed_values}"
            )
        self._sql_level = sql_level

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSqlCollectionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSqlCollectionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSqlCollectionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSqlCollectionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSqlCollectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSqlCollectionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSqlCollectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSqlCollectionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
