# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateSqlFirewallPolicyDetails(object):
    """
    Details to update the SQL Firewall policy.
    """

    #: A constant which can be used with the status property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    #: A constant which can be used with the enforcement_scope property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "ENFORCE_CONTEXT"
    ENFORCEMENT_SCOPE_ENFORCE_CONTEXT = "ENFORCE_CONTEXT"

    #: A constant which can be used with the enforcement_scope property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "ENFORCE_SQL"
    ENFORCEMENT_SCOPE_ENFORCE_SQL = "ENFORCE_SQL"

    #: A constant which can be used with the enforcement_scope property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "ENFORCE_ALL"
    ENFORCEMENT_SCOPE_ENFORCE_ALL = "ENFORCE_ALL"

    #: A constant which can be used with the violation_action property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "BLOCK"
    VIOLATION_ACTION_BLOCK = "BLOCK"

    #: A constant which can be used with the violation_action property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "OBSERVE"
    VIOLATION_ACTION_OBSERVE = "OBSERVE"

    #: A constant which can be used with the violation_audit property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "ENABLED"
    VIOLATION_AUDIT_ENABLED = "ENABLED"

    #: A constant which can be used with the violation_audit property of a UpdateSqlFirewallPolicyDetails.
    #: This constant has a value of "DISABLED"
    VIOLATION_AUDIT_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateSqlFirewallPolicyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateSqlFirewallPolicyDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateSqlFirewallPolicyDetails.
        :type description: str

        :param status:
            The value to assign to the status property of this UpdateSqlFirewallPolicyDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type status: str

        :param enforcement_scope:
            The value to assign to the enforcement_scope property of this UpdateSqlFirewallPolicyDetails.
            Allowed values for this property are: "ENFORCE_CONTEXT", "ENFORCE_SQL", "ENFORCE_ALL"
        :type enforcement_scope: str

        :param violation_action:
            The value to assign to the violation_action property of this UpdateSqlFirewallPolicyDetails.
            Allowed values for this property are: "BLOCK", "OBSERVE"
        :type violation_action: str

        :param violation_audit:
            The value to assign to the violation_audit property of this UpdateSqlFirewallPolicyDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type violation_audit: str

        :param allowed_client_ips:
            The value to assign to the allowed_client_ips property of this UpdateSqlFirewallPolicyDetails.
        :type allowed_client_ips: list[str]

        :param allowed_client_os_usernames:
            The value to assign to the allowed_client_os_usernames property of this UpdateSqlFirewallPolicyDetails.
        :type allowed_client_os_usernames: list[str]

        :param allowed_client_programs:
            The value to assign to the allowed_client_programs property of this UpdateSqlFirewallPolicyDetails.
        :type allowed_client_programs: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateSqlFirewallPolicyDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateSqlFirewallPolicyDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'status': 'str',
            'enforcement_scope': 'str',
            'violation_action': 'str',
            'violation_audit': 'str',
            'allowed_client_ips': 'list[str]',
            'allowed_client_os_usernames': 'list[str]',
            'allowed_client_programs': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'status': 'status',
            'enforcement_scope': 'enforcementScope',
            'violation_action': 'violationAction',
            'violation_audit': 'violationAudit',
            'allowed_client_ips': 'allowedClientIps',
            'allowed_client_os_usernames': 'allowedClientOsUsernames',
            'allowed_client_programs': 'allowedClientPrograms',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._status = None
        self._enforcement_scope = None
        self._violation_action = None
        self._violation_audit = None
        self._allowed_client_ips = None
        self._allowed_client_os_usernames = None
        self._allowed_client_programs = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateSqlFirewallPolicyDetails.
        The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.


        :return: The display_name of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateSqlFirewallPolicyDetails.
        The display name of the SQL Firewall policy. The name does not have to be unique, and it is changeable.


        :param display_name: The display_name of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateSqlFirewallPolicyDetails.
        The description of the SQL Firewall policy.


        :return: The description of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateSqlFirewallPolicyDetails.
        The description of the SQL Firewall policy.


        :param description: The description of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        self._description = description

    @property
    def status(self):
        """
        Gets the status of this UpdateSqlFirewallPolicyDetails.
        Specifies whether the SQL Firewall policy is enabled or disabled.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The status of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UpdateSqlFirewallPolicyDetails.
        Specifies whether the SQL Firewall policy is enabled or disabled.


        :param status: The status of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            raise ValueError(
                f"Invalid value for `status`, must be None or one of {allowed_values}"
            )
        self._status = status

    @property
    def enforcement_scope(self):
        """
        Gets the enforcement_scope of this UpdateSqlFirewallPolicyDetails.
        Specifies the SQL Firewall policy enforcement option.

        Allowed values for this property are: "ENFORCE_CONTEXT", "ENFORCE_SQL", "ENFORCE_ALL"


        :return: The enforcement_scope of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._enforcement_scope

    @enforcement_scope.setter
    def enforcement_scope(self, enforcement_scope):
        """
        Sets the enforcement_scope of this UpdateSqlFirewallPolicyDetails.
        Specifies the SQL Firewall policy enforcement option.


        :param enforcement_scope: The enforcement_scope of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        allowed_values = ["ENFORCE_CONTEXT", "ENFORCE_SQL", "ENFORCE_ALL"]
        if not value_allowed_none_or_none_sentinel(enforcement_scope, allowed_values):
            raise ValueError(
                f"Invalid value for `enforcement_scope`, must be None or one of {allowed_values}"
            )
        self._enforcement_scope = enforcement_scope

    @property
    def violation_action(self):
        """
        Gets the violation_action of this UpdateSqlFirewallPolicyDetails.
        Specifies the SQL Firewall action based on detection of SQL Firewall violations.

        Allowed values for this property are: "BLOCK", "OBSERVE"


        :return: The violation_action of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._violation_action

    @violation_action.setter
    def violation_action(self, violation_action):
        """
        Sets the violation_action of this UpdateSqlFirewallPolicyDetails.
        Specifies the SQL Firewall action based on detection of SQL Firewall violations.


        :param violation_action: The violation_action of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        allowed_values = ["BLOCK", "OBSERVE"]
        if not value_allowed_none_or_none_sentinel(violation_action, allowed_values):
            raise ValueError(
                f"Invalid value for `violation_action`, must be None or one of {allowed_values}"
            )
        self._violation_action = violation_action

    @property
    def violation_audit(self):
        """
        Gets the violation_audit of this UpdateSqlFirewallPolicyDetails.
        Specifies whether a unified audit policy should be enabled for auditing the SQL Firewall policy violations.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The violation_audit of this UpdateSqlFirewallPolicyDetails.
        :rtype: str
        """
        return self._violation_audit

    @violation_audit.setter
    def violation_audit(self, violation_audit):
        """
        Sets the violation_audit of this UpdateSqlFirewallPolicyDetails.
        Specifies whether a unified audit policy should be enabled for auditing the SQL Firewall policy violations.


        :param violation_audit: The violation_audit of this UpdateSqlFirewallPolicyDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(violation_audit, allowed_values):
            raise ValueError(
                f"Invalid value for `violation_audit`, must be None or one of {allowed_values}"
            )
        self._violation_audit = violation_audit

    @property
    def allowed_client_ips(self):
        """
        Gets the allowed_client_ips of this UpdateSqlFirewallPolicyDetails.
        List of allowed ip addresses for the SQL Firewall policy.


        :return: The allowed_client_ips of this UpdateSqlFirewallPolicyDetails.
        :rtype: list[str]
        """
        return self._allowed_client_ips

    @allowed_client_ips.setter
    def allowed_client_ips(self, allowed_client_ips):
        """
        Sets the allowed_client_ips of this UpdateSqlFirewallPolicyDetails.
        List of allowed ip addresses for the SQL Firewall policy.


        :param allowed_client_ips: The allowed_client_ips of this UpdateSqlFirewallPolicyDetails.
        :type: list[str]
        """
        self._allowed_client_ips = allowed_client_ips

    @property
    def allowed_client_os_usernames(self):
        """
        Gets the allowed_client_os_usernames of this UpdateSqlFirewallPolicyDetails.
        List of allowed operating system user names for the SQL Firewall policy.


        :return: The allowed_client_os_usernames of this UpdateSqlFirewallPolicyDetails.
        :rtype: list[str]
        """
        return self._allowed_client_os_usernames

    @allowed_client_os_usernames.setter
    def allowed_client_os_usernames(self, allowed_client_os_usernames):
        """
        Sets the allowed_client_os_usernames of this UpdateSqlFirewallPolicyDetails.
        List of allowed operating system user names for the SQL Firewall policy.


        :param allowed_client_os_usernames: The allowed_client_os_usernames of this UpdateSqlFirewallPolicyDetails.
        :type: list[str]
        """
        self._allowed_client_os_usernames = allowed_client_os_usernames

    @property
    def allowed_client_programs(self):
        """
        Gets the allowed_client_programs of this UpdateSqlFirewallPolicyDetails.
        List of allowed client programs for the SQL Firewall policy.


        :return: The allowed_client_programs of this UpdateSqlFirewallPolicyDetails.
        :rtype: list[str]
        """
        return self._allowed_client_programs

    @allowed_client_programs.setter
    def allowed_client_programs(self, allowed_client_programs):
        """
        Sets the allowed_client_programs of this UpdateSqlFirewallPolicyDetails.
        List of allowed client programs for the SQL Firewall policy.


        :param allowed_client_programs: The allowed_client_programs of this UpdateSqlFirewallPolicyDetails.
        :type: list[str]
        """
        self._allowed_client_programs = allowed_client_programs

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateSqlFirewallPolicyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateSqlFirewallPolicyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateSqlFirewallPolicyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateSqlFirewallPolicyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateSqlFirewallPolicyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateSqlFirewallPolicyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateSqlFirewallPolicyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateSqlFirewallPolicyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
