# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AcdAvmResourceStats(object):
    """
    Resource usage by autonomous container database in a particular VM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AcdAvmResourceStats object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AcdAvmResourceStats.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this AcdAvmResourceStats.
        :type display_name: str

        :param provisioned_cpus:
            The value to assign to the provisioned_cpus property of this AcdAvmResourceStats.
        :type provisioned_cpus: float

        :param used_cpus:
            The value to assign to the used_cpus property of this AcdAvmResourceStats.
        :type used_cpus: float

        :param reserved_cpus:
            The value to assign to the reserved_cpus property of this AcdAvmResourceStats.
        :type reserved_cpus: float

        :param reclaimable_cpus:
            The value to assign to the reclaimable_cpus property of this AcdAvmResourceStats.
        :type reclaimable_cpus: float

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'provisioned_cpus': 'float',
            'used_cpus': 'float',
            'reserved_cpus': 'float',
            'reclaimable_cpus': 'float'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'provisioned_cpus': 'provisionedCpus',
            'used_cpus': 'usedCpus',
            'reserved_cpus': 'reservedCpus',
            'reclaimable_cpus': 'reclaimableCpus'
        }

        self._id = None
        self._display_name = None
        self._provisioned_cpus = None
        self._used_cpus = None
        self._reserved_cpus = None
        self._reclaimable_cpus = None

    @property
    def id(self):
        """
        Gets the id of this AcdAvmResourceStats.
        The `OCID`__ of the Autonomous VM.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this AcdAvmResourceStats.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AcdAvmResourceStats.
        The `OCID`__ of the Autonomous VM.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this AcdAvmResourceStats.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this AcdAvmResourceStats.
        The user-friendly name for the Autonomous VM. The name does not need to be unique.


        :return: The display_name of this AcdAvmResourceStats.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AcdAvmResourceStats.
        The user-friendly name for the Autonomous VM. The name does not need to be unique.


        :param display_name: The display_name of this AcdAvmResourceStats.
        :type: str
        """
        self._display_name = display_name

    @property
    def provisioned_cpus(self):
        """
        Gets the provisioned_cpus of this AcdAvmResourceStats.
        CPUs/cores assigned to Autonomous Databases for the ACD instance in given Autonomus VM.


        :return: The provisioned_cpus of this AcdAvmResourceStats.
        :rtype: float
        """
        return self._provisioned_cpus

    @provisioned_cpus.setter
    def provisioned_cpus(self, provisioned_cpus):
        """
        Sets the provisioned_cpus of this AcdAvmResourceStats.
        CPUs/cores assigned to Autonomous Databases for the ACD instance in given Autonomus VM.


        :param provisioned_cpus: The provisioned_cpus of this AcdAvmResourceStats.
        :type: float
        """
        self._provisioned_cpus = provisioned_cpus

    @property
    def used_cpus(self):
        """
        Gets the used_cpus of this AcdAvmResourceStats.
        CPUs/cores assigned to the ACD instance in given Autonomous VM. Sum of provisioned,
        reserved and reclaimable CPUs/ cores to the ACD instance.


        :return: The used_cpus of this AcdAvmResourceStats.
        :rtype: float
        """
        return self._used_cpus

    @used_cpus.setter
    def used_cpus(self, used_cpus):
        """
        Sets the used_cpus of this AcdAvmResourceStats.
        CPUs/cores assigned to the ACD instance in given Autonomous VM. Sum of provisioned,
        reserved and reclaimable CPUs/ cores to the ACD instance.


        :param used_cpus: The used_cpus of this AcdAvmResourceStats.
        :type: float
        """
        self._used_cpus = used_cpus

    @property
    def reserved_cpus(self):
        """
        Gets the reserved_cpus of this AcdAvmResourceStats.
        CPUs/cores reserved for scalability, resilliency and other overheads.
        This includes failover, autoscaling and idle instance overhead.


        :return: The reserved_cpus of this AcdAvmResourceStats.
        :rtype: float
        """
        return self._reserved_cpus

    @reserved_cpus.setter
    def reserved_cpus(self, reserved_cpus):
        """
        Sets the reserved_cpus of this AcdAvmResourceStats.
        CPUs/cores reserved for scalability, resilliency and other overheads.
        This includes failover, autoscaling and idle instance overhead.


        :param reserved_cpus: The reserved_cpus of this AcdAvmResourceStats.
        :type: float
        """
        self._reserved_cpus = reserved_cpus

    @property
    def reclaimable_cpus(self):
        """
        Gets the reclaimable_cpus of this AcdAvmResourceStats.
        CPUs/cores that continue to be included in the count of OCPUs available to the
        Autonomous Container Database in given Autonomous VM, even after one of its
        Autonomous Database is terminated or scaled down. You can release them to the available
        OCPUs at its parent AVMC level by restarting the Autonomous Container Database.


        :return: The reclaimable_cpus of this AcdAvmResourceStats.
        :rtype: float
        """
        return self._reclaimable_cpus

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, reclaimable_cpus):
        """
        Sets the reclaimable_cpus of this AcdAvmResourceStats.
        CPUs/cores that continue to be included in the count of OCPUs available to the
        Autonomous Container Database in given Autonomous VM, even after one of its
        Autonomous Database is terminated or scaled down. You can release them to the available
        OCPUs at its parent AVMC level by restarting the Autonomous Container Database.


        :param reclaimable_cpus: The reclaimable_cpus of this AcdAvmResourceStats.
        :type: float
        """
        self._reclaimable_cpus = reclaimable_cpus

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
