# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerateAutonomousDatabaseWalletDetails(object):
    """
    Details to create and download an Oracle Autonomous Database wallet.
    """

    #: A constant which can be used with the generate_type property of a GenerateAutonomousDatabaseWalletDetails.
    #: This constant has a value of "ALL"
    GENERATE_TYPE_ALL = "ALL"

    #: A constant which can be used with the generate_type property of a GenerateAutonomousDatabaseWalletDetails.
    #: This constant has a value of "SINGLE"
    GENERATE_TYPE_SINGLE = "SINGLE"

    def __init__(self, **kwargs):
        """
        Initializes a new GenerateAutonomousDatabaseWalletDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param generate_type:
            The value to assign to the generate_type property of this GenerateAutonomousDatabaseWalletDetails.
            Allowed values for this property are: "ALL", "SINGLE"
        :type generate_type: str

        :param password:
            The value to assign to the password property of this GenerateAutonomousDatabaseWalletDetails.
        :type password: str

        :param is_regional:
            The value to assign to the is_regional property of this GenerateAutonomousDatabaseWalletDetails.
        :type is_regional: bool

        """
        self.swagger_types = {
            'generate_type': 'str',
            'password': 'str',
            'is_regional': 'bool'
        }

        self.attribute_map = {
            'generate_type': 'generateType',
            'password': 'password',
            'is_regional': 'isRegional'
        }

        self._generate_type = None
        self._password = None
        self._is_regional = None

    @property
    def generate_type(self):
        """
        Gets the generate_type of this GenerateAutonomousDatabaseWalletDetails.
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.

        Allowed values for this property are: "ALL", "SINGLE"


        :return: The generate_type of this GenerateAutonomousDatabaseWalletDetails.
        :rtype: str
        """
        return self._generate_type

    @generate_type.setter
    def generate_type(self, generate_type):
        """
        Sets the generate_type of this GenerateAutonomousDatabaseWalletDetails.
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.


        :param generate_type: The generate_type of this GenerateAutonomousDatabaseWalletDetails.
        :type: str
        """
        allowed_values = ["ALL", "SINGLE"]
        if not value_allowed_none_or_none_sentinel(generate_type, allowed_values):
            raise ValueError(
                f"Invalid value for `generate_type`, must be None or one of {allowed_values}"
            )
        self._generate_type = generate_type

    @property
    def password(self):
        """
        **[Required]** Gets the password of this GenerateAutonomousDatabaseWalletDetails.
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        :return: The password of this GenerateAutonomousDatabaseWalletDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this GenerateAutonomousDatabaseWalletDetails.
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        :param password: The password of this GenerateAutonomousDatabaseWalletDetails.
        :type: str
        """
        self._password = password

    @property
    def is_regional(self):
        """
        Gets the is_regional of this GenerateAutonomousDatabaseWalletDetails.
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.


        :return: The is_regional of this GenerateAutonomousDatabaseWalletDetails.
        :rtype: bool
        """
        return self._is_regional

    @is_regional.setter
    def is_regional(self, is_regional):
        """
        Sets the is_regional of this GenerateAutonomousDatabaseWalletDetails.
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.


        :param is_regional: The is_regional of this GenerateAutonomousDatabaseWalletDetails.
        :type: bool
        """
        self._is_regional = is_regional

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
