# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PluggableDatabaseNodeLevelDetails(object):
    """
    Pluggable Database Node Level Details.
    """

    #: A constant which can be used with the open_mode property of a PluggableDatabaseNodeLevelDetails.
    #: This constant has a value of "READ_ONLY"
    OPEN_MODE_READ_ONLY = "READ_ONLY"

    #: A constant which can be used with the open_mode property of a PluggableDatabaseNodeLevelDetails.
    #: This constant has a value of "READ_WRITE"
    OPEN_MODE_READ_WRITE = "READ_WRITE"

    #: A constant which can be used with the open_mode property of a PluggableDatabaseNodeLevelDetails.
    #: This constant has a value of "MOUNTED"
    OPEN_MODE_MOUNTED = "MOUNTED"

    #: A constant which can be used with the open_mode property of a PluggableDatabaseNodeLevelDetails.
    #: This constant has a value of "MIGRATE"
    OPEN_MODE_MIGRATE = "MIGRATE"

    def __init__(self, **kwargs):
        """
        Initializes a new PluggableDatabaseNodeLevelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param node_name:
            The value to assign to the node_name property of this PluggableDatabaseNodeLevelDetails.
        :type node_name: str

        :param open_mode:
            The value to assign to the open_mode property of this PluggableDatabaseNodeLevelDetails.
            Allowed values for this property are: "READ_ONLY", "READ_WRITE", "MOUNTED", "MIGRATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type open_mode: str

        """
        self.swagger_types = {
            'node_name': 'str',
            'open_mode': 'str'
        }

        self.attribute_map = {
            'node_name': 'nodeName',
            'open_mode': 'openMode'
        }

        self._node_name = None
        self._open_mode = None

    @property
    def node_name(self):
        """
        **[Required]** Gets the node_name of this PluggableDatabaseNodeLevelDetails.
        The Node name of the Database Instance.


        :return: The node_name of this PluggableDatabaseNodeLevelDetails.
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """
        Sets the node_name of this PluggableDatabaseNodeLevelDetails.
        The Node name of the Database Instance.


        :param node_name: The node_name of this PluggableDatabaseNodeLevelDetails.
        :type: str
        """
        self._node_name = node_name

    @property
    def open_mode(self):
        """
        **[Required]** Gets the open_mode of this PluggableDatabaseNodeLevelDetails.
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).

        Allowed values for this property are: "READ_ONLY", "READ_WRITE", "MOUNTED", "MIGRATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The open_mode of this PluggableDatabaseNodeLevelDetails.
        :rtype: str
        """
        return self._open_mode

    @open_mode.setter
    def open_mode(self, open_mode):
        """
        Sets the open_mode of this PluggableDatabaseNodeLevelDetails.
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).


        :param open_mode: The open_mode of this PluggableDatabaseNodeLevelDetails.
        :type: str
        """
        allowed_values = ["READ_ONLY", "READ_WRITE", "MOUNTED", "MIGRATE"]
        if not value_allowed_none_or_none_sentinel(open_mode, allowed_values):
            open_mode = 'UNKNOWN_ENUM_VALUE'
        self._open_mode = open_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
