# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseSummary(object):
    """
    The details of the Managed MySQL Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ManagedMySqlDatabaseSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ManagedMySqlDatabaseSummary.
        :type compartment_id: str

        :param db_name:
            The value to assign to the db_name property of this ManagedMySqlDatabaseSummary.
        :type db_name: str

        :param db_version:
            The value to assign to the db_version property of this ManagedMySqlDatabaseSummary.
        :type db_version: str

        :param time_created:
            The value to assign to the time_created property of this ManagedMySqlDatabaseSummary.
        :type time_created: datetime

        :param name:
            The value to assign to the name property of this ManagedMySqlDatabaseSummary.
        :type name: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'db_name': 'str',
            'db_version': 'str',
            'time_created': 'datetime',
            'name': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'db_name': 'dbName',
            'db_version': 'dbVersion',
            'time_created': 'timeCreated',
            'name': 'name'
        }

        self._id = None
        self._compartment_id = None
        self._db_name = None
        self._db_version = None
        self._time_created = None
        self._name = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ManagedMySqlDatabaseSummary.
        The OCID of the Managed MySQL Database.


        :return: The id of this ManagedMySqlDatabaseSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ManagedMySqlDatabaseSummary.
        The OCID of the Managed MySQL Database.


        :param id: The id of this ManagedMySqlDatabaseSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ManagedMySqlDatabaseSummary.
        The OCID of the compartment.


        :return: The compartment_id of this ManagedMySqlDatabaseSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ManagedMySqlDatabaseSummary.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this ManagedMySqlDatabaseSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_name(self):
        """
        **[Required]** Gets the db_name of this ManagedMySqlDatabaseSummary.
        The name of the MySQL Database.


        :return: The db_name of this ManagedMySqlDatabaseSummary.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this ManagedMySqlDatabaseSummary.
        The name of the MySQL Database.


        :param db_name: The db_name of this ManagedMySqlDatabaseSummary.
        :type: str
        """
        self._db_name = db_name

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this ManagedMySqlDatabaseSummary.
        The version of the MySQL Database.


        :return: The db_version of this ManagedMySqlDatabaseSummary.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this ManagedMySqlDatabaseSummary.
        The version of the MySQL Database.


        :param db_version: The db_version of this ManagedMySqlDatabaseSummary.
        :type: str
        """
        self._db_version = db_version

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ManagedMySqlDatabaseSummary.
        The date and time the Managed MySQL Database was created.


        :return: The time_created of this ManagedMySqlDatabaseSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ManagedMySqlDatabaseSummary.
        The date and time the Managed MySQL Database was created.


        :param time_created: The time_created of this ManagedMySqlDatabaseSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ManagedMySqlDatabaseSummary.
        The name of the Managed MySQL Database.


        :return: The name of this ManagedMySqlDatabaseSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ManagedMySqlDatabaseSummary.
        The name of the Managed MySQL Database.


        :param name: The name of this ManagedMySqlDatabaseSummary.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
