# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDatabaseToolsConnectionDetails(object):
    """
    Details for the new Database Tools connection.
    """

    #: A constant which can be used with the type property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "ORACLE_DATABASE"
    TYPE_ORACLE_DATABASE = "ORACLE_DATABASE"

    #: A constant which can be used with the type property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "MYSQL"
    TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the type property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "POSTGRESQL"
    TYPE_POSTGRESQL = "POSTGRESQL"

    #: A constant which can be used with the type property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "GENERIC_JDBC"
    TYPE_GENERIC_JDBC = "GENERIC_JDBC"

    #: A constant which can be used with the runtime_support property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "SUPPORTED"
    RUNTIME_SUPPORT_SUPPORTED = "SUPPORTED"

    #: A constant which can be used with the runtime_support property of a CreateDatabaseToolsConnectionDetails.
    #: This constant has a value of "UNSUPPORTED"
    RUNTIME_SUPPORT_UNSUPPORTED = "UNSUPPORTED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDatabaseToolsConnectionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_tools.models.CreateDatabaseToolsConnectionGenericJdbcDetails`
        * :class:`~oci.database_tools.models.CreateDatabaseToolsConnectionPostgresqlDetails`
        * :class:`~oci.database_tools.models.CreateDatabaseToolsConnectionMySqlDetails`
        * :class:`~oci.database_tools.models.CreateDatabaseToolsConnectionOracleDatabaseDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDatabaseToolsConnectionDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDatabaseToolsConnectionDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDatabaseToolsConnectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDatabaseToolsConnectionDetails.
        :type freeform_tags: dict(str, str)

        :param locks:
            The value to assign to the locks property of this CreateDatabaseToolsConnectionDetails.
        :type locks: list[oci.database_tools.models.ResourceLock]

        :param type:
            The value to assign to the type property of this CreateDatabaseToolsConnectionDetails.
            Allowed values for this property are: "ORACLE_DATABASE", "MYSQL", "POSTGRESQL", "GENERIC_JDBC"
        :type type: str

        :param runtime_support:
            The value to assign to the runtime_support property of this CreateDatabaseToolsConnectionDetails.
            Allowed values for this property are: "SUPPORTED", "UNSUPPORTED"
        :type runtime_support: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'locks': 'list[ResourceLock]',
            'type': 'str',
            'runtime_support': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'locks': 'locks',
            'type': 'type',
            'runtime_support': 'runtimeSupport'
        }

        self._display_name = None
        self._compartment_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._locks = None
        self._type = None
        self._runtime_support = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'GENERIC_JDBC':
            return 'CreateDatabaseToolsConnectionGenericJdbcDetails'

        if type == 'POSTGRESQL':
            return 'CreateDatabaseToolsConnectionPostgresqlDetails'

        if type == 'MYSQL':
            return 'CreateDatabaseToolsConnectionMySqlDetails'

        if type == 'ORACLE_DATABASE':
            return 'CreateDatabaseToolsConnectionOracleDatabaseDetails'
        else:
            return 'CreateDatabaseToolsConnectionDetails'

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDatabaseToolsConnectionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateDatabaseToolsConnectionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDatabaseToolsConnectionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDatabaseToolsConnectionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDatabaseToolsConnectionDetails.
        The `OCID`__ of the compartment containing the Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDatabaseToolsConnectionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDatabaseToolsConnectionDetails.
        The `OCID`__ of the compartment containing the Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDatabaseToolsConnectionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDatabaseToolsConnectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDatabaseToolsConnectionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDatabaseToolsConnectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDatabaseToolsConnectionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDatabaseToolsConnectionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDatabaseToolsConnectionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDatabaseToolsConnectionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDatabaseToolsConnectionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def locks(self):
        """
        Gets the locks of this CreateDatabaseToolsConnectionDetails.
        Locks associated with this resource.


        :return: The locks of this CreateDatabaseToolsConnectionDetails.
        :rtype: list[oci.database_tools.models.ResourceLock]
        """
        return self._locks

    @locks.setter
    def locks(self, locks):
        """
        Sets the locks of this CreateDatabaseToolsConnectionDetails.
        Locks associated with this resource.


        :param locks: The locks of this CreateDatabaseToolsConnectionDetails.
        :type: list[oci.database_tools.models.ResourceLock]
        """
        self._locks = locks

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateDatabaseToolsConnectionDetails.
        The DatabaseToolsConnection type.

        Allowed values for this property are: "ORACLE_DATABASE", "MYSQL", "POSTGRESQL", "GENERIC_JDBC"


        :return: The type of this CreateDatabaseToolsConnectionDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateDatabaseToolsConnectionDetails.
        The DatabaseToolsConnection type.


        :param type: The type of this CreateDatabaseToolsConnectionDetails.
        :type: str
        """
        allowed_values = ["ORACLE_DATABASE", "MYSQL", "POSTGRESQL", "GENERIC_JDBC"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def runtime_support(self):
        """
        Gets the runtime_support of this CreateDatabaseToolsConnectionDetails.
        Specifies whether this connection is supported by the Database Tools Runtime.

        Allowed values for this property are: "SUPPORTED", "UNSUPPORTED"


        :return: The runtime_support of this CreateDatabaseToolsConnectionDetails.
        :rtype: str
        """
        return self._runtime_support

    @runtime_support.setter
    def runtime_support(self, runtime_support):
        """
        Sets the runtime_support of this CreateDatabaseToolsConnectionDetails.
        Specifies whether this connection is supported by the Database Tools Runtime.


        :param runtime_support: The runtime_support of this CreateDatabaseToolsConnectionDetails.
        :type: str
        """
        allowed_values = ["SUPPORTED", "UNSUPPORTED"]
        if not value_allowed_none_or_none_sentinel(runtime_support, allowed_values):
            raise ValueError(
                f"Invalid value for `runtime_support`, must be None or one of {allowed_values}"
            )
        self._runtime_support = runtime_support

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
