# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .reschedule_deployment_upgrade_details import RescheduleDeploymentUpgradeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RescheduleDeploymentUpgradeToDateDetails(RescheduleDeploymentUpgradeDetails):
    """
    Definition of the additional attributes for default deployment upgrade cancel.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RescheduleDeploymentUpgradeToDateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.RescheduleDeploymentUpgradeToDateDetails.type` attribute
        of this class is ``RESCHEDULE_TO_DATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this RescheduleDeploymentUpgradeToDateDetails.
            Allowed values for this property are: "RESCHEDULE_TO_DATE"
        :type type: str

        :param time_schedule:
            The value to assign to the time_schedule property of this RescheduleDeploymentUpgradeToDateDetails.
        :type time_schedule: datetime

        """
        self.swagger_types = {
            'type': 'str',
            'time_schedule': 'datetime'
        }

        self.attribute_map = {
            'type': 'type',
            'time_schedule': 'timeSchedule'
        }

        self._type = None
        self._time_schedule = None
        self._type = 'RESCHEDULE_TO_DATE'

    @property
    def time_schedule(self):
        """
        **[Required]** Gets the time_schedule of this RescheduleDeploymentUpgradeToDateDetails.
        The time of upgrade schedule. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_schedule of this RescheduleDeploymentUpgradeToDateDetails.
        :rtype: datetime
        """
        return self._time_schedule

    @time_schedule.setter
    def time_schedule(self, time_schedule):
        """
        Sets the time_schedule of this RescheduleDeploymentUpgradeToDateDetails.
        The time of upgrade schedule. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_schedule: The time_schedule of this RescheduleDeploymentUpgradeToDateDetails.
        :type: datetime
        """
        self._time_schedule = time_schedule

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
