# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BrandingSetting(object):
    """
    Brand Settings schema
    """

    #: A constant which can be used with the idcs_prevented_operations property of a BrandingSetting.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a BrandingSetting.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a BrandingSetting.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    def __init__(self, **kwargs):
        """
        Initializes a new BrandingSetting object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BrandingSetting.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this BrandingSetting.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this BrandingSetting.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this BrandingSetting.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this BrandingSetting.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this BrandingSetting.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this BrandingSetting.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this BrandingSetting.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this BrandingSetting.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this BrandingSetting.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this BrandingSetting.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this BrandingSetting.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this BrandingSetting.
        :type tenancy_ocid: str

        :param external_id:
            The value to assign to the external_id property of this BrandingSetting.
        :type external_id: str

        :param custom_branding:
            The value to assign to the custom_branding property of this BrandingSetting.
        :type custom_branding: bool

        :param preferred_language:
            The value to assign to the preferred_language property of this BrandingSetting.
        :type preferred_language: str

        :param timezone:
            The value to assign to the timezone property of this BrandingSetting.
        :type timezone: str

        :param locale:
            The value to assign to the locale property of this BrandingSetting.
        :type locale: str

        :param enable_terms_of_use:
            The value to assign to the enable_terms_of_use property of this BrandingSetting.
        :type enable_terms_of_use: bool

        :param terms_of_use_url:
            The value to assign to the terms_of_use_url property of this BrandingSetting.
        :type terms_of_use_url: str

        :param privacy_policy_url:
            The value to assign to the privacy_policy_url property of this BrandingSetting.
        :type privacy_policy_url: str

        :param is_hosted_page:
            The value to assign to the is_hosted_page property of this BrandingSetting.
        :type is_hosted_page: bool

        :param custom_html_location:
            The value to assign to the custom_html_location property of this BrandingSetting.
        :type custom_html_location: str

        :param custom_css_location:
            The value to assign to the custom_css_location property of this BrandingSetting.
        :type custom_css_location: str

        :param custom_translation:
            The value to assign to the custom_translation property of this BrandingSetting.
        :type custom_translation: str

        :param default_company_names:
            The value to assign to the default_company_names property of this BrandingSetting.
        :type default_company_names: list[oci.identity_domains.models.BrandingSettingsDefaultCompanyNames]

        :param default_login_texts:
            The value to assign to the default_login_texts property of this BrandingSetting.
        :type default_login_texts: list[oci.identity_domains.models.BrandingSettingsDefaultLoginTexts]

        :param default_images:
            The value to assign to the default_images property of this BrandingSetting.
        :type default_images: list[oci.identity_domains.models.BrandingSettingsDefaultImages]

        :param company_names:
            The value to assign to the company_names property of this BrandingSetting.
        :type company_names: list[oci.identity_domains.models.BrandingSettingsCompanyNames]

        :param login_texts:
            The value to assign to the login_texts property of this BrandingSetting.
        :type login_texts: list[oci.identity_domains.models.BrandingSettingsLoginTexts]

        :param images:
            The value to assign to the images property of this BrandingSetting.
        :type images: list[oci.identity_domains.models.BrandingSettingsImages]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'external_id': 'str',
            'custom_branding': 'bool',
            'preferred_language': 'str',
            'timezone': 'str',
            'locale': 'str',
            'enable_terms_of_use': 'bool',
            'terms_of_use_url': 'str',
            'privacy_policy_url': 'str',
            'is_hosted_page': 'bool',
            'custom_html_location': 'str',
            'custom_css_location': 'str',
            'custom_translation': 'str',
            'default_company_names': 'list[BrandingSettingsDefaultCompanyNames]',
            'default_login_texts': 'list[BrandingSettingsDefaultLoginTexts]',
            'default_images': 'list[BrandingSettingsDefaultImages]',
            'company_names': 'list[BrandingSettingsCompanyNames]',
            'login_texts': 'list[BrandingSettingsLoginTexts]',
            'images': 'list[BrandingSettingsImages]'
        }

        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'external_id': 'externalId',
            'custom_branding': 'customBranding',
            'preferred_language': 'preferredLanguage',
            'timezone': 'timezone',
            'locale': 'locale',
            'enable_terms_of_use': 'enableTermsOfUse',
            'terms_of_use_url': 'termsOfUseUrl',
            'privacy_policy_url': 'privacyPolicyUrl',
            'is_hosted_page': 'isHostedPage',
            'custom_html_location': 'customHtmlLocation',
            'custom_css_location': 'customCssLocation',
            'custom_translation': 'customTranslation',
            'default_company_names': 'defaultCompanyNames',
            'default_login_texts': 'defaultLoginTexts',
            'default_images': 'defaultImages',
            'company_names': 'companyNames',
            'login_texts': 'loginTexts',
            'images': 'images'
        }

        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._external_id = None
        self._custom_branding = None
        self._preferred_language = None
        self._timezone = None
        self._locale = None
        self._enable_terms_of_use = None
        self._terms_of_use_url = None
        self._privacy_policy_url = None
        self._is_hosted_page = None
        self._custom_html_location = None
        self._custom_css_location = None
        self._custom_translation = None
        self._default_company_names = None
        self._default_login_texts = None
        self._default_images = None
        self._company_names = None
        self._login_texts = None
        self._images = None

    @property
    def id(self):
        """
        Gets the id of this BrandingSetting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this BrandingSetting.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BrandingSetting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this BrandingSetting.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this BrandingSetting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this BrandingSetting.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this BrandingSetting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this BrandingSetting.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this BrandingSetting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this BrandingSetting.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this BrandingSetting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this BrandingSetting.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this BrandingSetting.

        :return: The meta of this BrandingSetting.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this BrandingSetting.

        :param meta: The meta of this BrandingSetting.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this BrandingSetting.

        :return: The idcs_created_by of this BrandingSetting.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this BrandingSetting.

        :param idcs_created_by: The idcs_created_by of this BrandingSetting.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this BrandingSetting.

        :return: The idcs_last_modified_by of this BrandingSetting.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this BrandingSetting.

        :param idcs_last_modified_by: The idcs_last_modified_by of this BrandingSetting.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this BrandingSetting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this BrandingSetting.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this BrandingSetting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this BrandingSetting.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this BrandingSetting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this BrandingSetting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this BrandingSetting.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this BrandingSetting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this BrandingSetting.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this BrandingSetting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this BrandingSetting.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this BrandingSetting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this BrandingSetting.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this BrandingSetting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this BrandingSetting.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this BrandingSetting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this BrandingSetting.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this BrandingSetting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this BrandingSetting.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this BrandingSetting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this BrandingSetting.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this BrandingSetting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this BrandingSetting.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this BrandingSetting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this BrandingSetting.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this BrandingSetting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this BrandingSetting.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def external_id(self):
        """
        Gets the external_id of this BrandingSetting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The external_id of this BrandingSetting.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this BrandingSetting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param external_id: The external_id of this BrandingSetting.
        :type: str
        """
        self._external_id = external_id

    @property
    def custom_branding(self):
        """
        Gets the custom_branding of this BrandingSetting.
        Indicates if the branding is default or is custom branding

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The custom_branding of this BrandingSetting.
        :rtype: bool
        """
        return self._custom_branding

    @custom_branding.setter
    def custom_branding(self, custom_branding):
        """
        Sets the custom_branding of this BrandingSetting.
        Indicates if the branding is default or is custom branding

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param custom_branding: The custom_branding of this BrandingSetting.
        :type: bool
        """
        self._custom_branding = custom_branding

    @property
    def preferred_language(self):
        """
        Gets the preferred_language of this BrandingSetting.
        Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The preferred_language of this BrandingSetting.
        :rtype: str
        """
        return self._preferred_language

    @preferred_language.setter
    def preferred_language(self, preferred_language):
        """
        Sets the preferred_language of this BrandingSetting.
        Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param preferred_language: The preferred_language of this BrandingSetting.
        :type: str
        """
        self._preferred_language = preferred_language

    @property
    def timezone(self):
        """
        Gets the timezone of this BrandingSetting.
        User's timezone

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The timezone of this BrandingSetting.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this BrandingSetting.
        User's timezone

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param timezone: The timezone of this BrandingSetting.
        :type: str
        """
        self._timezone = timezone

    @property
    def locale(self):
        """
        Gets the locale of this BrandingSetting.
        Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The locale of this BrandingSetting.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this BrandingSetting.
        Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param locale: The locale of this BrandingSetting.
        :type: str
        """
        self._locale = locale

    @property
    def enable_terms_of_use(self):
        """
        Gets the enable_terms_of_use of this BrandingSetting.
        Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enable_terms_of_use of this BrandingSetting.
        :rtype: bool
        """
        return self._enable_terms_of_use

    @enable_terms_of_use.setter
    def enable_terms_of_use(self, enable_terms_of_use):
        """
        Sets the enable_terms_of_use of this BrandingSetting.
        Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enable_terms_of_use: The enable_terms_of_use of this BrandingSetting.
        :type: bool
        """
        self._enable_terms_of_use = enable_terms_of_use

    @property
    def terms_of_use_url(self):
        """
        Gets the terms_of_use_url of this BrandingSetting.
        Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The terms_of_use_url of this BrandingSetting.
        :rtype: str
        """
        return self._terms_of_use_url

    @terms_of_use_url.setter
    def terms_of_use_url(self, terms_of_use_url):
        """
        Sets the terms_of_use_url of this BrandingSetting.
        Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param terms_of_use_url: The terms_of_use_url of this BrandingSetting.
        :type: str
        """
        self._terms_of_use_url = terms_of_use_url

    @property
    def privacy_policy_url(self):
        """
        Gets the privacy_policy_url of this BrandingSetting.
        Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The privacy_policy_url of this BrandingSetting.
        :rtype: str
        """
        return self._privacy_policy_url

    @privacy_policy_url.setter
    def privacy_policy_url(self, privacy_policy_url):
        """
        Sets the privacy_policy_url of this BrandingSetting.
        Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param privacy_policy_url: The privacy_policy_url of this BrandingSetting.
        :type: str
        """
        self._privacy_policy_url = privacy_policy_url

    @property
    def is_hosted_page(self):
        """
        Gets the is_hosted_page of this BrandingSetting.
        Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_hosted_page of this BrandingSetting.
        :rtype: bool
        """
        return self._is_hosted_page

    @is_hosted_page.setter
    def is_hosted_page(self, is_hosted_page):
        """
        Sets the is_hosted_page of this BrandingSetting.
        Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_hosted_page: The is_hosted_page of this BrandingSetting.
        :type: bool
        """
        self._is_hosted_page = is_hosted_page

    @property
    def custom_html_location(self):
        """
        Gets the custom_html_location of this BrandingSetting.
        Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_html_location of this BrandingSetting.
        :rtype: str
        """
        return self._custom_html_location

    @custom_html_location.setter
    def custom_html_location(self, custom_html_location):
        """
        Sets the custom_html_location of this BrandingSetting.
        Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_html_location: The custom_html_location of this BrandingSetting.
        :type: str
        """
        self._custom_html_location = custom_html_location

    @property
    def custom_css_location(self):
        """
        Gets the custom_css_location of this BrandingSetting.
        Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_css_location of this BrandingSetting.
        :rtype: str
        """
        return self._custom_css_location

    @custom_css_location.setter
    def custom_css_location(self, custom_css_location):
        """
        Sets the custom_css_location of this BrandingSetting.
        Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_css_location: The custom_css_location of this BrandingSetting.
        :type: str
        """
        self._custom_css_location = custom_css_location

    @property
    def custom_translation(self):
        """
        Gets the custom_translation of this BrandingSetting.
        Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_translation of this BrandingSetting.
        :rtype: str
        """
        return self._custom_translation

    @custom_translation.setter
    def custom_translation(self, custom_translation):
        """
        Sets the custom_translation of this BrandingSetting.
        Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_translation: The custom_translation of this BrandingSetting.
        :type: str
        """
        self._custom_translation = custom_translation

    @property
    def default_company_names(self):
        """
        Gets the default_company_names of this BrandingSetting.
        Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_company_names of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsDefaultCompanyNames]
        """
        return self._default_company_names

    @default_company_names.setter
    def default_company_names(self, default_company_names):
        """
        Sets the default_company_names of this BrandingSetting.
        Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_company_names: The default_company_names of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsDefaultCompanyNames]
        """
        self._default_company_names = default_company_names

    @property
    def default_login_texts(self):
        """
        Gets the default_login_texts of this BrandingSetting.
        Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_login_texts of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsDefaultLoginTexts]
        """
        return self._default_login_texts

    @default_login_texts.setter
    def default_login_texts(self, default_login_texts):
        """
        Sets the default_login_texts of this BrandingSetting.
        Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_login_texts: The default_login_texts of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsDefaultLoginTexts]
        """
        self._default_login_texts = default_login_texts

    @property
    def default_images(self):
        """
        Gets the default_images of this BrandingSetting.
        References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_images of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsDefaultImages]
        """
        return self._default_images

    @default_images.setter
    def default_images(self, default_images):
        """
        Sets the default_images of this BrandingSetting.
        References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_images: The default_images of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsDefaultImages]
        """
        self._default_images = default_images

    @property
    def company_names(self):
        """
        Gets the company_names of this BrandingSetting.
        Name of the company in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The company_names of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsCompanyNames]
        """
        return self._company_names

    @company_names.setter
    def company_names(self, company_names):
        """
        Sets the company_names of this BrandingSetting.
        Name of the company in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param company_names: The company_names of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsCompanyNames]
        """
        self._company_names = company_names

    @property
    def login_texts(self):
        """
        Gets the login_texts of this BrandingSetting.
        Login text in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The login_texts of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsLoginTexts]
        """
        return self._login_texts

    @login_texts.setter
    def login_texts(self, login_texts):
        """
        Sets the login_texts of this BrandingSetting.
        Login text in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param login_texts: The login_texts of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsLoginTexts]
        """
        self._login_texts = login_texts

    @property
    def images(self):
        """
        Gets the images of this BrandingSetting.
        References to various images

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The images of this BrandingSetting.
        :rtype: list[oci.identity_domains.models.BrandingSettingsImages]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this BrandingSetting.
        References to various images

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param images: The images of this BrandingSetting.
        :type: list[oci.identity_domains.models.BrandingSettingsImages]
        """
        self._images = images

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
