# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MyAppApp(object):
    """
    Application on which the account is based

    **SCIM++ Properties:**
    - idcsSearchable: true
    - multiValued: false
    - mutability: readOnly
    - required: true
    - returned: default
    - type: complex
    - uniqueness: none
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MyAppApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this MyAppApp.
        :type value: str

        :param ref:
            The value to assign to the ref property of this MyAppApp.
        :type ref: str

        :param display:
            The value to assign to the display property of this MyAppApp.
        :type display: str

        :param description:
            The value to assign to the description property of this MyAppApp.
        :type description: str

        :param is_login_target:
            The value to assign to the is_login_target property of this MyAppApp.
        :type is_login_target: bool

        :param show_in_my_apps:
            The value to assign to the show_in_my_apps property of this MyAppApp.
        :type show_in_my_apps: bool

        :param is_alias_app:
            The value to assign to the is_alias_app property of this MyAppApp.
        :type is_alias_app: bool

        :param active:
            The value to assign to the active property of this MyAppApp.
        :type active: bool

        :param login_mechanism:
            The value to assign to the login_mechanism property of this MyAppApp.
        :type login_mechanism: str

        :param app_icon:
            The value to assign to the app_icon property of this MyAppApp.
        :type app_icon: str

        :param app_thumbnail:
            The value to assign to the app_thumbnail property of this MyAppApp.
        :type app_thumbnail: str

        :param is_opc_service:
            The value to assign to the is_opc_service property of this MyAppApp.
        :type is_opc_service: bool

        :param service_type_urn:
            The value to assign to the service_type_urn property of this MyAppApp.
        :type service_type_urn: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'display': 'str',
            'description': 'str',
            'is_login_target': 'bool',
            'show_in_my_apps': 'bool',
            'is_alias_app': 'bool',
            'active': 'bool',
            'login_mechanism': 'str',
            'app_icon': 'str',
            'app_thumbnail': 'str',
            'is_opc_service': 'bool',
            'service_type_urn': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'display': 'display',
            'description': 'description',
            'is_login_target': 'isLoginTarget',
            'show_in_my_apps': 'showInMyApps',
            'is_alias_app': 'isAliasApp',
            'active': 'active',
            'login_mechanism': 'loginMechanism',
            'app_icon': 'appIcon',
            'app_thumbnail': 'appThumbnail',
            'is_opc_service': 'isOPCService',
            'service_type_urn': 'serviceTypeURN'
        }

        self._value = None
        self._ref = None
        self._display = None
        self._description = None
        self._is_login_target = None
        self._show_in_my_apps = None
        self._is_alias_app = None
        self._active = None
        self._login_mechanism = None
        self._app_icon = None
        self._app_thumbnail = None
        self._is_opc_service = None
        self._service_type_urn = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this MyAppApp.
        Application identifier

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this MyAppApp.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this MyAppApp.
        Application identifier

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this MyAppApp.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this MyAppApp.
        Application URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this MyAppApp.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this MyAppApp.
        Application URI

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this MyAppApp.
        :type: str
        """
        self._ref = ref

    @property
    def display(self):
        """
        Gets the display of this MyAppApp.
        Application display name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The display of this MyAppApp.
        :rtype: str
        """
        return self._display

    @display.setter
    def display(self, display):
        """
        Sets the display of this MyAppApp.
        Application display name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param display: The display of this MyAppApp.
        :type: str
        """
        self._display = display

    @property
    def description(self):
        """
        Gets the description of this MyAppApp.
        Application description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this MyAppApp.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MyAppApp.
        Application description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this MyAppApp.
        :type: str
        """
        self._description = description

    @property
    def is_login_target(self):
        """
        Gets the is_login_target of this MyAppApp.
        If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_login_target of this MyAppApp.
        :rtype: bool
        """
        return self._is_login_target

    @is_login_target.setter
    def is_login_target(self, is_login_target):
        """
        Sets the is_login_target of this MyAppApp.
        If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_login_target: The is_login_target of this MyAppApp.
        :type: bool
        """
        self._is_login_target = is_login_target

    @property
    def show_in_my_apps(self):
        """
        Gets the show_in_my_apps of this MyAppApp.
        If true, this App will be displayed in the MyApps page of each end-user who has access to this App.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The show_in_my_apps of this MyAppApp.
        :rtype: bool
        """
        return self._show_in_my_apps

    @show_in_my_apps.setter
    def show_in_my_apps(self, show_in_my_apps):
        """
        Sets the show_in_my_apps of this MyAppApp.
        If true, this App will be displayed in the MyApps page of each end-user who has access to this App.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param show_in_my_apps: The show_in_my_apps of this MyAppApp.
        :type: bool
        """
        self._show_in_my_apps = show_in_my_apps

    @property
    def is_alias_app(self):
        """
        Gets the is_alias_app of this MyAppApp.
        If true, this App is an AliasApp and it cannot be granted to an end user directly

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: writeOnly
         - required: false
         - returned: never
         - type: boolean
         - uniqueness: none


        :return: The is_alias_app of this MyAppApp.
        :rtype: bool
        """
        return self._is_alias_app

    @is_alias_app.setter
    def is_alias_app(self, is_alias_app):
        """
        Sets the is_alias_app of this MyAppApp.
        If true, this App is an AliasApp and it cannot be granted to an end user directly

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: writeOnly
         - required: false
         - returned: never
         - type: boolean
         - uniqueness: none


        :param is_alias_app: The is_alias_app of this MyAppApp.
        :type: bool
        """
        self._is_alias_app = is_alias_app

    @property
    def active(self):
        """
        Gets the active of this MyAppApp.
        If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The active of this MyAppApp.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this MyAppApp.
        If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param active: The active of this MyAppApp.
        :type: bool
        """
        self._active = active

    @property
    def login_mechanism(self):
        """
        Gets the login_mechanism of this MyAppApp.
        The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The login_mechanism of this MyAppApp.
        :rtype: str
        """
        return self._login_mechanism

    @login_mechanism.setter
    def login_mechanism(self, login_mechanism):
        """
        Sets the login_mechanism of this MyAppApp.
        The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param login_mechanism: The login_mechanism of this MyAppApp.
        :type: str
        """
        self._login_mechanism = login_mechanism

    @property
    def app_icon(self):
        """
        Gets the app_icon of this MyAppApp.
        Application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The app_icon of this MyAppApp.
        :rtype: str
        """
        return self._app_icon

    @app_icon.setter
    def app_icon(self, app_icon):
        """
        Sets the app_icon of this MyAppApp.
        Application icon.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param app_icon: The app_icon of this MyAppApp.
        :type: str
        """
        self._app_icon = app_icon

    @property
    def app_thumbnail(self):
        """
        Gets the app_thumbnail of this MyAppApp.
        Application thumbnail.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The app_thumbnail of this MyAppApp.
        :rtype: str
        """
        return self._app_thumbnail

    @app_thumbnail.setter
    def app_thumbnail(self, app_thumbnail):
        """
        Sets the app_thumbnail of this MyAppApp.
        Application thumbnail.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param app_thumbnail: The app_thumbnail of this MyAppApp.
        :type: str
        """
        self._app_thumbnail = app_thumbnail

    @property
    def is_opc_service(self):
        """
        Gets the is_opc_service of this MyAppApp.
        If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_opc_service of this MyAppApp.
        :rtype: bool
        """
        return self._is_opc_service

    @is_opc_service.setter
    def is_opc_service(self, is_opc_service):
        """
        Sets the is_opc_service of this MyAppApp.
        If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_opc_service: The is_opc_service of this MyAppApp.
        :type: bool
        """
        self._is_opc_service = is_opc_service

    @property
    def service_type_urn(self):
        """
        Gets the service_type_urn of this MyAppApp.
        This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The service_type_urn of this MyAppApp.
        :rtype: str
        """
        return self._service_type_urn

    @service_type_urn.setter
    def service_type_urn(self, service_type_urn):
        """
        Sets the service_type_urn of this MyAppApp.
        This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param service_type_urn: The service_type_urn of this MyAppApp.
        :type: str
        """
        self._service_type_urn = service_type_urn

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
