# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaLocalizedCanonicalValues(object):
    """
    A collection of Localized canonical values.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaLocalizedCanonicalValues object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this SchemaLocalizedCanonicalValues.
        :type value: str

        :param canonical_value:
            The value to assign to the canonical_value property of this SchemaLocalizedCanonicalValues.
        :type canonical_value: list[str]

        :param locale:
            The value to assign to the locale property of this SchemaLocalizedCanonicalValues.
        :type locale: str

        """
        self.swagger_types = {
            'value': 'str',
            'canonical_value': 'list[str]',
            'locale': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'canonical_value': 'canonicalValue',
            'locale': 'locale'
        }

        self._value = None
        self._canonical_value = None
        self._locale = None

    @property
    def value(self):
        """
        Gets the value of this SchemaLocalizedCanonicalValues.
        Localized display value

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this SchemaLocalizedCanonicalValues.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this SchemaLocalizedCanonicalValues.
        Localized display value

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this SchemaLocalizedCanonicalValues.
        :type: str
        """
        self._value = value

    @property
    def canonical_value(self):
        """
        Gets the canonical_value of this SchemaLocalizedCanonicalValues.
        Canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The canonical_value of this SchemaLocalizedCanonicalValues.
        :rtype: list[str]
        """
        return self._canonical_value

    @canonical_value.setter
    def canonical_value(self, canonical_value):
        """
        Sets the canonical_value of this SchemaLocalizedCanonicalValues.
        Canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param canonical_value: The canonical_value of this SchemaLocalizedCanonicalValues.
        :type: list[str]
        """
        self._canonical_value = canonical_value

    @property
    def locale(self):
        """
        Gets the locale of this SchemaLocalizedCanonicalValues.
        Locale used

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The locale of this SchemaLocalizedCanonicalValues.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this SchemaLocalizedCanonicalValues.
        Locale used

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param locale: The locale of this SchemaLocalizedCanonicalValues.
        :type: str
        """
        self._locale = locale

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
