# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaReferencedResourceTypeUniqueAttributeNameMappings(object):
    """
    This attribute specifies the mapping of \"uniqueAttributeNameForDisplay\" attributes(s) of the referenced resource with the columnHeaderName(s). This attribute should be given in the idcsCsvAttributeNameMappings when uniqueAttributeNameForDisplay contains more than one attribute.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaReferencedResourceTypeUniqueAttributeNameMappings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_type_attribute_name:
            The value to assign to the resource_type_attribute_name property of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :type resource_type_attribute_name: str

        :param maps_from_column_name:
            The value to assign to the maps_from_column_name property of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :type maps_from_column_name: str

        """
        self.swagger_types = {
            'resource_type_attribute_name': 'str',
            'maps_from_column_name': 'str'
        }

        self.attribute_map = {
            'resource_type_attribute_name': 'resourceTypeAttributeName',
            'maps_from_column_name': 'mapsFromColumnName'
        }

        self._resource_type_attribute_name = None
        self._maps_from_column_name = None

    @property
    def resource_type_attribute_name(self):
        """
        Gets the resource_type_attribute_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        Specifies the name of the attribute given in \\\"uniqueAttributeNameForDisplay\\\" in the Resource type definition.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The resource_type_attribute_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :rtype: str
        """
        return self._resource_type_attribute_name

    @resource_type_attribute_name.setter
    def resource_type_attribute_name(self, resource_type_attribute_name):
        """
        Sets the resource_type_attribute_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        Specifies the name of the attribute given in \\\"uniqueAttributeNameForDisplay\\\" in the Resource type definition.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param resource_type_attribute_name: The resource_type_attribute_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :type: str
        """
        self._resource_type_attribute_name = resource_type_attribute_name

    @property
    def maps_from_column_name(self):
        """
        Gets the maps_from_column_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        Specifies the CSV column header name that maps to the corresponding \\\"uniqueAttributeNameForDisplay\\\" attribute of the resource.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The maps_from_column_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :rtype: str
        """
        return self._maps_from_column_name

    @maps_from_column_name.setter
    def maps_from_column_name(self, maps_from_column_name):
        """
        Sets the maps_from_column_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        Specifies the CSV column header name that maps to the corresponding \\\"uniqueAttributeNameForDisplay\\\" attribute of the resource.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param maps_from_column_name: The maps_from_column_name of this SchemaReferencedResourceTypeUniqueAttributeNameMappings.
        :type: str
        """
        self._maps_from_column_name = maps_from_column_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
