# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaResolveValueUsingResourceType(object):
    """
    This attribute gives a maps for resolving Resource Type after reading it's value from \"csvColumnForResolvingResourceType\" attribute
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaResolveValueUsingResourceType object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value_to_be_resolved:
            The value to assign to the value_to_be_resolved property of this SchemaResolveValueUsingResourceType.
        :type value_to_be_resolved: str

        :param resolve_by:
            The value to assign to the resolve_by property of this SchemaResolveValueUsingResourceType.
        :type resolve_by: str

        """
        self.swagger_types = {
            'value_to_be_resolved': 'str',
            'resolve_by': 'str'
        }

        self.attribute_map = {
            'value_to_be_resolved': 'valueToBeResolved',
            'resolve_by': 'resolveBy'
        }

        self._value_to_be_resolved = None
        self._resolve_by = None

    @property
    def value_to_be_resolved(self):
        """
        Gets the value_to_be_resolved of this SchemaResolveValueUsingResourceType.
        Specifies the value which should be resolved by a Resource type.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value_to_be_resolved of this SchemaResolveValueUsingResourceType.
        :rtype: str
        """
        return self._value_to_be_resolved

    @value_to_be_resolved.setter
    def value_to_be_resolved(self, value_to_be_resolved):
        """
        Sets the value_to_be_resolved of this SchemaResolveValueUsingResourceType.
        Specifies the value which should be resolved by a Resource type.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param value_to_be_resolved: The value_to_be_resolved of this SchemaResolveValueUsingResourceType.
        :type: str
        """
        self._value_to_be_resolved = value_to_be_resolved

    @property
    def resolve_by(self):
        """
        Gets the resolve_by of this SchemaResolveValueUsingResourceType.
        Specifies the Resource type with which the value given in \\\"valueToBeResolved\\\" attribute should be resolved

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The resolve_by of this SchemaResolveValueUsingResourceType.
        :rtype: str
        """
        return self._resolve_by

    @resolve_by.setter
    def resolve_by(self, resolve_by):
        """
        Sets the resolve_by of this SchemaResolveValueUsingResourceType.
        Specifies the Resource type with which the value given in \\\"valueToBeResolved\\\" attribute should be resolved

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param resolve_by: The resolve_by of this SchemaResolveValueUsingResourceType.
        :type: str
        """
        self._resolve_by = resolve_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
