# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateJavaDownloadReportDetails(object):
    """
    Attributes to create a Java download report.
    """

    #: A constant which can be used with the sort_by property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "timeDownloaded"
    SORT_BY_TIME_DOWNLOADED = "timeDownloaded"

    #: A constant which can be used with the sort_by property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "downloadSourceId"
    SORT_BY_DOWNLOAD_SOURCE_ID = "downloadSourceId"

    #: A constant which can be used with the sort_by property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "downloadType"
    SORT_BY_DOWNLOAD_TYPE = "downloadType"

    #: A constant which can be used with the sort_order property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "ASC"
    SORT_ORDER_ASC = "ASC"

    #: A constant which can be used with the sort_order property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "DESC"
    SORT_ORDER_DESC = "DESC"

    #: A constant which can be used with the format property of a CreateJavaDownloadReportDetails.
    #: This constant has a value of "CSV"
    FORMAT_CSV = "CSV"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateJavaDownloadReportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateJavaDownloadReportDetails.
        :type compartment_id: str

        :param time_start:
            The value to assign to the time_start property of this CreateJavaDownloadReportDetails.
        :type time_start: datetime

        :param time_end:
            The value to assign to the time_end property of this CreateJavaDownloadReportDetails.
        :type time_end: datetime

        :param sort_by:
            The value to assign to the sort_by property of this CreateJavaDownloadReportDetails.
            Allowed values for this property are: "timeDownloaded", "downloadSourceId", "downloadType"
        :type sort_by: str

        :param sort_order:
            The value to assign to the sort_order property of this CreateJavaDownloadReportDetails.
            Allowed values for this property are: "ASC", "DESC"
        :type sort_order: str

        :param format:
            The value to assign to the format property of this CreateJavaDownloadReportDetails.
            Allowed values for this property are: "CSV"
        :type format: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'time_start': 'datetime',
            'time_end': 'datetime',
            'sort_by': 'str',
            'sort_order': 'str',
            'format': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'time_start': 'timeStart',
            'time_end': 'timeEnd',
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder',
            'format': 'format'
        }

        self._compartment_id = None
        self._time_start = None
        self._time_end = None
        self._sort_by = None
        self._sort_order = None
        self._format = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateJavaDownloadReportDetails.
        The compartment `OCID`__ here should be
        the tenancy OCID.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateJavaDownloadReportDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateJavaDownloadReportDetails.
        The compartment `OCID`__ here should be
        the tenancy OCID.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateJavaDownloadReportDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_start(self):
        """
        Gets the time_start of this CreateJavaDownloadReportDetails.
        The start time from when download records have to be included (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_start of this CreateJavaDownloadReportDetails.
        :rtype: datetime
        """
        return self._time_start

    @time_start.setter
    def time_start(self, time_start):
        """
        Sets the time_start of this CreateJavaDownloadReportDetails.
        The start time from when download records have to be included (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_start: The time_start of this CreateJavaDownloadReportDetails.
        :type: datetime
        """
        self._time_start = time_start

    @property
    def time_end(self):
        """
        Gets the time_end of this CreateJavaDownloadReportDetails.
        The end time until when the download records have to be included (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_end of this CreateJavaDownloadReportDetails.
        :rtype: datetime
        """
        return self._time_end

    @time_end.setter
    def time_end(self, time_end):
        """
        Sets the time_end of this CreateJavaDownloadReportDetails.
        The end time until when the download records have to be included (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_end: The time_end of this CreateJavaDownloadReportDetails.
        :type: datetime
        """
        self._time_end = time_end

    @property
    def sort_by(self):
        """
        Gets the sort_by of this CreateJavaDownloadReportDetails.
        The property to be used for sorting the reports.

        Allowed values for this property are: "timeDownloaded", "downloadSourceId", "downloadType"


        :return: The sort_by of this CreateJavaDownloadReportDetails.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this CreateJavaDownloadReportDetails.
        The property to be used for sorting the reports.


        :param sort_by: The sort_by of this CreateJavaDownloadReportDetails.
        :type: str
        """
        allowed_values = ["timeDownloaded", "downloadSourceId", "downloadType"]
        if not value_allowed_none_or_none_sentinel(sort_by, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_by`, must be None or one of {allowed_values}"
            )
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this CreateJavaDownloadReportDetails.
        The sort order for the reports.

        Allowed values for this property are: "ASC", "DESC"


        :return: The sort_order of this CreateJavaDownloadReportDetails.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this CreateJavaDownloadReportDetails.
        The sort order for the reports.


        :param sort_order: The sort_order of this CreateJavaDownloadReportDetails.
        :type: str
        """
        allowed_values = ["ASC", "DESC"]
        if not value_allowed_none_or_none_sentinel(sort_order, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_order`, must be None or one of {allowed_values}"
            )
        self._sort_order = sort_order

    @property
    def format(self):
        """
        **[Required]** Gets the format of this CreateJavaDownloadReportDetails.
        The format of the report that is generated.

        Allowed values for this property are: "CSV"


        :return: The format of this CreateJavaDownloadReportDetails.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """
        Sets the format of this CreateJavaDownloadReportDetails.
        The format of the report that is generated.


        :param format: The format of this CreateJavaDownloadReportDetails.
        :type: str
        """
        allowed_values = ["CSV"]
        if not value_allowed_none_or_none_sentinel(format, allowed_values):
            raise ValueError(
                f"Invalid value for `format`, must be None or one of {allowed_values}"
            )
        self._format = format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
