# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DownloadUrl(object):
    """
    Download Url object for the Java artifact.
    """

    #: A constant which can be used with the download_url_type property of a DownloadUrl.
    #: This constant has a value of "OSS"
    DOWNLOAD_URL_TYPE_OSS = "OSS"

    #: A constant which can be used with the download_url_type property of a DownloadUrl.
    #: This constant has a value of "CDN"
    DOWNLOAD_URL_TYPE_CDN = "CDN"

    def __init__(self, **kwargs):
        """
        Initializes a new DownloadUrl object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param download_url:
            The value to assign to the download_url property of this DownloadUrl.
        :type download_url: str

        :param download_url_type:
            The value to assign to the download_url_type property of this DownloadUrl.
            Allowed values for this property are: "OSS", "CDN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type download_url_type: str

        """
        self.swagger_types = {
            'download_url': 'str',
            'download_url_type': 'str'
        }

        self.attribute_map = {
            'download_url': 'downloadUrl',
            'download_url_type': 'downloadUrlType'
        }

        self._download_url = None
        self._download_url_type = None

    @property
    def download_url(self):
        """
        **[Required]** Gets the download_url of this DownloadUrl.
        The URL for downloading the artifact.


        :return: The download_url of this DownloadUrl.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """
        Sets the download_url of this DownloadUrl.
        The URL for downloading the artifact.


        :param download_url: The download_url of this DownloadUrl.
        :type: str
        """
        self._download_url = download_url

    @property
    def download_url_type(self):
        """
        **[Required]** Gets the download_url_type of this DownloadUrl.
        The type of download URL.

        Allowed values for this property are: "OSS", "CDN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The download_url_type of this DownloadUrl.
        :rtype: str
        """
        return self._download_url_type

    @download_url_type.setter
    def download_url_type(self, download_url_type):
        """
        Sets the download_url_type of this DownloadUrl.
        The type of download URL.


        :param download_url_type: The download_url_type of this DownloadUrl.
        :type: str
        """
        allowed_values = ["OSS", "CDN"]
        if not value_allowed_none_or_none_sentinel(download_url_type, allowed_values):
            download_url_type = 'UNKNOWN_ENUM_VALUE'
        self._download_url_type = download_url_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
