# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501

from .create_mapped_secret_details import CreateMappedSecretDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateVaultMappedSecretDetails(CreateMappedSecretDetails):
    """
    The request details to be created in the Vault Mapped Secret for the policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateVaultMappedSecretDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.network_firewall.models.CreateVaultMappedSecretDetails.source` attribute
        of this class is ``OCI_VAULT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateVaultMappedSecretDetails.
        :type name: str

        :param source:
            The value to assign to the source property of this CreateVaultMappedSecretDetails.
        :type source: str

        :param type:
            The value to assign to the type property of this CreateVaultMappedSecretDetails.
            Allowed values for this property are: "SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"
        :type type: str

        :param vault_secret_id:
            The value to assign to the vault_secret_id property of this CreateVaultMappedSecretDetails.
        :type vault_secret_id: str

        :param version_number:
            The value to assign to the version_number property of this CreateVaultMappedSecretDetails.
        :type version_number: int

        """
        self.swagger_types = {
            'name': 'str',
            'source': 'str',
            'type': 'str',
            'vault_secret_id': 'str',
            'version_number': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'source': 'source',
            'type': 'type',
            'vault_secret_id': 'vaultSecretId',
            'version_number': 'versionNumber'
        }

        self._name = None
        self._source = None
        self._type = None
        self._vault_secret_id = None
        self._version_number = None
        self._source = 'OCI_VAULT'

    @property
    def vault_secret_id(self):
        """
        **[Required]** Gets the vault_secret_id of this CreateVaultMappedSecretDetails.
        OCID for the Vault Secret to be used.


        :return: The vault_secret_id of this CreateVaultMappedSecretDetails.
        :rtype: str
        """
        return self._vault_secret_id

    @vault_secret_id.setter
    def vault_secret_id(self, vault_secret_id):
        """
        Sets the vault_secret_id of this CreateVaultMappedSecretDetails.
        OCID for the Vault Secret to be used.


        :param vault_secret_id: The vault_secret_id of this CreateVaultMappedSecretDetails.
        :type: str
        """
        self._vault_secret_id = vault_secret_id

    @property
    def version_number(self):
        """
        **[Required]** Gets the version_number of this CreateVaultMappedSecretDetails.
        Version number of the secret to be used.


        :return: The version_number of this CreateVaultMappedSecretDetails.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this CreateVaultMappedSecretDetails.
        Version number of the secret to be used.


        :param version_number: The version_number of this CreateVaultMappedSecretDetails.
        :type: int
        """
        self._version_number = version_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
