# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateReplicaDetails(object):
    """
    Specifications for the new replica
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateReplicaDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateReplicaDetails.
        :type compartment_id: str

        :param region:
            The value to assign to the region property of this CreateReplicaDetails.
        :type region: str

        :param max_read_units:
            The value to assign to the max_read_units property of this CreateReplicaDetails.
        :type max_read_units: int

        :param max_write_units:
            The value to assign to the max_write_units property of this CreateReplicaDetails.
        :type max_write_units: int

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'region': 'str',
            'max_read_units': 'int',
            'max_write_units': 'int'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'region': 'region',
            'max_read_units': 'maxReadUnits',
            'max_write_units': 'maxWriteUnits'
        }

        self._compartment_id = None
        self._region = None
        self._max_read_units = None
        self._max_write_units = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateReplicaDetails.
        The OCID of the table's compartment.  Required
        if the tableNameOrId path parameter is a table name.
        Optional if tableNameOrId is an OCID.  If tableNameOrId
        is an OCID, and compartmentId is supplied, the latter
        must match the identified table's compartmentId.


        :return: The compartment_id of this CreateReplicaDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateReplicaDetails.
        The OCID of the table's compartment.  Required
        if the tableNameOrId path parameter is a table name.
        Optional if tableNameOrId is an OCID.  If tableNameOrId
        is an OCID, and compartmentId is supplied, the latter
        must match the identified table's compartmentId.


        :param compartment_id: The compartment_id of this CreateReplicaDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def region(self):
        """
        **[Required]** Gets the region of this CreateReplicaDetails.
        Name of the remote region in standard OCI format, i.e. us-ashburn-1


        :return: The region of this CreateReplicaDetails.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this CreateReplicaDetails.
        Name of the remote region in standard OCI format, i.e. us-ashburn-1


        :param region: The region of this CreateReplicaDetails.
        :type: str
        """
        self._region = region

    @property
    def max_read_units(self):
        """
        Gets the max_read_units of this CreateReplicaDetails.
        Maximum sustained read throughput limit for the new replica table.
        If not specified, the local table's read limit is used.


        :return: The max_read_units of this CreateReplicaDetails.
        :rtype: int
        """
        return self._max_read_units

    @max_read_units.setter
    def max_read_units(self, max_read_units):
        """
        Sets the max_read_units of this CreateReplicaDetails.
        Maximum sustained read throughput limit for the new replica table.
        If not specified, the local table's read limit is used.


        :param max_read_units: The max_read_units of this CreateReplicaDetails.
        :type: int
        """
        self._max_read_units = max_read_units

    @property
    def max_write_units(self):
        """
        Gets the max_write_units of this CreateReplicaDetails.
        Maximum sustained write throughput limit for the new replica table.
        If not specified, the local table's write limit is used.


        :return: The max_write_units of this CreateReplicaDetails.
        :rtype: int
        """
        return self._max_write_units

    @max_write_units.setter
    def max_write_units(self, max_write_units):
        """
        Sets the max_write_units of this CreateReplicaDetails.
        Maximum sustained write throughput limit for the new replica table.
        If not specified, the local table's write limit is used.


        :param max_write_units: The max_write_units of this CreateReplicaDetails.
        :type: int
        """
        self._max_write_units = max_write_units

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
