# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemDetails(object):
    """
    Information about the database system associated with a backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param system_type:
            The value to assign to the system_type property of this DbSystemDetails.
        :type system_type: str

        :param db_version:
            The value to assign to the db_version property of this DbSystemDetails.
        :type db_version: str

        """
        self.swagger_types = {
            'system_type': 'str',
            'db_version': 'str'
        }

        self.attribute_map = {
            'system_type': 'systemType',
            'db_version': 'dbVersion'
        }

        self._system_type = None
        self._db_version = None

    @property
    def system_type(self):
        """
        **[Required]** Gets the system_type of this DbSystemDetails.
        Type of the database system.


        :return: The system_type of this DbSystemDetails.
        :rtype: str
        """
        return self._system_type

    @system_type.setter
    def system_type(self, system_type):
        """
        Sets the system_type of this DbSystemDetails.
        Type of the database system.


        :param system_type: The system_type of this DbSystemDetails.
        :type: str
        """
        self._system_type = system_type

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this DbSystemDetails.
        The major and minor versions of the database system software.


        :return: The db_version of this DbSystemDetails.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this DbSystemDetails.
        The major and minor versions of the database system software.


        :param db_version: The db_version of this DbSystemDetails.
        :type: str
        """
        self._db_version = db_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
