# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RestartDbInstanceInDbSystemDetails(object):
    """
    Database instance node restart parameters.
    """

    #: A constant which can be used with the restart_type property of a RestartDbInstanceInDbSystemDetails.
    #: This constant has a value of "NORMAL"
    RESTART_TYPE_NORMAL = "NORMAL"

    #: A constant which can be used with the restart_type property of a RestartDbInstanceInDbSystemDetails.
    #: This constant has a value of "NODE_REBOOT"
    RESTART_TYPE_NODE_REBOOT = "NODE_REBOOT"

    def __init__(self, **kwargs):
        """
        Initializes a new RestartDbInstanceInDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_instance_id:
            The value to assign to the db_instance_id property of this RestartDbInstanceInDbSystemDetails.
        :type db_instance_id: str

        :param restart_type:
            The value to assign to the restart_type property of this RestartDbInstanceInDbSystemDetails.
            Allowed values for this property are: "NORMAL", "NODE_REBOOT"
        :type restart_type: str

        """
        self.swagger_types = {
            'db_instance_id': 'str',
            'restart_type': 'str'
        }

        self.attribute_map = {
            'db_instance_id': 'dbInstanceId',
            'restart_type': 'restartType'
        }

        self._db_instance_id = None
        self._restart_type = None

    @property
    def db_instance_id(self):
        """
        **[Required]** Gets the db_instance_id of this RestartDbInstanceInDbSystemDetails.
        A unique identifier for the database instance, or node.


        :return: The db_instance_id of this RestartDbInstanceInDbSystemDetails.
        :rtype: str
        """
        return self._db_instance_id

    @db_instance_id.setter
    def db_instance_id(self, db_instance_id):
        """
        Sets the db_instance_id of this RestartDbInstanceInDbSystemDetails.
        A unique identifier for the database instance, or node.


        :param db_instance_id: The db_instance_id of this RestartDbInstanceInDbSystemDetails.
        :type: str
        """
        self._db_instance_id = db_instance_id

    @property
    def restart_type(self):
        """
        **[Required]** Gets the restart_type of this RestartDbInstanceInDbSystemDetails.
        The restart type for the database instance.

        Allowed values for this property are: "NORMAL", "NODE_REBOOT"


        :return: The restart_type of this RestartDbInstanceInDbSystemDetails.
        :rtype: str
        """
        return self._restart_type

    @restart_type.setter
    def restart_type(self, restart_type):
        """
        Sets the restart_type of this RestartDbInstanceInDbSystemDetails.
        The restart type for the database instance.


        :param restart_type: The restart_type of this RestartDbInstanceInDbSystemDetails.
        :type: str
        """
        allowed_values = ["NORMAL", "NODE_REBOOT"]
        if not value_allowed_none_or_none_sentinel(restart_type, allowed_values):
            raise ValueError(
                f"Invalid value for `restart_type`, must be None or one of {allowed_values}"
            )
        self._restart_type = restart_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
