# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230401


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReviveWorkflowInstanceDetails(object):
    """
    The parameters for reviving failed workflow
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReviveWorkflowInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param workflow_instance_id:
            The value to assign to the workflow_instance_id property of this ReviveWorkflowInstanceDetails.
        :type workflow_instance_id: str

        :param workflow_instance_name:
            The value to assign to the workflow_instance_name property of this ReviveWorkflowInstanceDetails.
        :type workflow_instance_name: str

        """
        self.swagger_types = {
            'workflow_instance_id': 'str',
            'workflow_instance_name': 'str'
        }

        self.attribute_map = {
            'workflow_instance_id': 'workflowInstanceId',
            'workflow_instance_name': 'workflowInstanceName'
        }

        self._workflow_instance_id = None
        self._workflow_instance_name = None

    @property
    def workflow_instance_id(self):
        """
        Gets the workflow_instance_id of this ReviveWorkflowInstanceDetails.
        Id of failed workflow


        :return: The workflow_instance_id of this ReviveWorkflowInstanceDetails.
        :rtype: str
        """
        return self._workflow_instance_id

    @workflow_instance_id.setter
    def workflow_instance_id(self, workflow_instance_id):
        """
        Sets the workflow_instance_id of this ReviveWorkflowInstanceDetails.
        Id of failed workflow


        :param workflow_instance_id: The workflow_instance_id of this ReviveWorkflowInstanceDetails.
        :type: str
        """
        self._workflow_instance_id = workflow_instance_id

    @property
    def workflow_instance_name(self):
        """
        Gets the workflow_instance_name of this ReviveWorkflowInstanceDetails.
        Service specific workflow instance name


        :return: The workflow_instance_name of this ReviveWorkflowInstanceDetails.
        :rtype: str
        """
        return self._workflow_instance_name

    @workflow_instance_name.setter
    def workflow_instance_name(self, workflow_instance_name):
        """
        Sets the workflow_instance_name of this ReviveWorkflowInstanceDetails.
        Service specific workflow instance name


        :param workflow_instance_name: The workflow_instance_name of this ReviveWorkflowInstanceDetails.
        :type: str
        """
        self._workflow_instance_name = workflow_instance_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
