# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequestUsageCarbonEmissionsDetails(object):
    """
    Details for the '/usageCarbonEmissions' query.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RequestUsageCarbonEmissionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenant_id:
            The value to assign to the tenant_id property of this RequestUsageCarbonEmissionsDetails.
        :type tenant_id: str

        :param time_usage_started:
            The value to assign to the time_usage_started property of this RequestUsageCarbonEmissionsDetails.
        :type time_usage_started: datetime

        :param time_usage_ended:
            The value to assign to the time_usage_ended property of this RequestUsageCarbonEmissionsDetails.
        :type time_usage_ended: datetime

        :param is_aggregate_by_time:
            The value to assign to the is_aggregate_by_time property of this RequestUsageCarbonEmissionsDetails.
        :type is_aggregate_by_time: bool

        :param group_by:
            The value to assign to the group_by property of this RequestUsageCarbonEmissionsDetails.
        :type group_by: list[str]

        :param group_by_tag:
            The value to assign to the group_by_tag property of this RequestUsageCarbonEmissionsDetails.
        :type group_by_tag: list[oci.usage_api.models.Tag]

        :param compartment_depth:
            The value to assign to the compartment_depth property of this RequestUsageCarbonEmissionsDetails.
        :type compartment_depth: int

        :param filter:
            The value to assign to the filter property of this RequestUsageCarbonEmissionsDetails.
        :type filter: oci.usage_api.models.Filter

        """
        self.swagger_types = {
            'tenant_id': 'str',
            'time_usage_started': 'datetime',
            'time_usage_ended': 'datetime',
            'is_aggregate_by_time': 'bool',
            'group_by': 'list[str]',
            'group_by_tag': 'list[Tag]',
            'compartment_depth': 'int',
            'filter': 'Filter'
        }

        self.attribute_map = {
            'tenant_id': 'tenantId',
            'time_usage_started': 'timeUsageStarted',
            'time_usage_ended': 'timeUsageEnded',
            'is_aggregate_by_time': 'isAggregateByTime',
            'group_by': 'groupBy',
            'group_by_tag': 'groupByTag',
            'compartment_depth': 'compartmentDepth',
            'filter': 'filter'
        }

        self._tenant_id = None
        self._time_usage_started = None
        self._time_usage_ended = None
        self._is_aggregate_by_time = None
        self._group_by = None
        self._group_by_tag = None
        self._compartment_depth = None
        self._filter = None

    @property
    def tenant_id(self):
        """
        **[Required]** Gets the tenant_id of this RequestUsageCarbonEmissionsDetails.
        Tenant ID.


        :return: The tenant_id of this RequestUsageCarbonEmissionsDetails.
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """
        Sets the tenant_id of this RequestUsageCarbonEmissionsDetails.
        Tenant ID.


        :param tenant_id: The tenant_id of this RequestUsageCarbonEmissionsDetails.
        :type: str
        """
        self._tenant_id = tenant_id

    @property
    def time_usage_started(self):
        """
        **[Required]** Gets the time_usage_started of this RequestUsageCarbonEmissionsDetails.
        The usage start time.


        :return: The time_usage_started of this RequestUsageCarbonEmissionsDetails.
        :rtype: datetime
        """
        return self._time_usage_started

    @time_usage_started.setter
    def time_usage_started(self, time_usage_started):
        """
        Sets the time_usage_started of this RequestUsageCarbonEmissionsDetails.
        The usage start time.


        :param time_usage_started: The time_usage_started of this RequestUsageCarbonEmissionsDetails.
        :type: datetime
        """
        self._time_usage_started = time_usage_started

    @property
    def time_usage_ended(self):
        """
        **[Required]** Gets the time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        The usage end time.


        :return: The time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        :rtype: datetime
        """
        return self._time_usage_ended

    @time_usage_ended.setter
    def time_usage_ended(self, time_usage_ended):
        """
        Sets the time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        The usage end time.


        :param time_usage_ended: The time_usage_ended of this RequestUsageCarbonEmissionsDetails.
        :type: datetime
        """
        self._time_usage_ended = time_usage_ended

    @property
    def is_aggregate_by_time(self):
        """
        Gets the is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        Specifies whether aggregated by time. If isAggregateByTime is true, all usage carbon emissions over the query time period will be added up.


        :return: The is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        :rtype: bool
        """
        return self._is_aggregate_by_time

    @is_aggregate_by_time.setter
    def is_aggregate_by_time(self, is_aggregate_by_time):
        """
        Sets the is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        Specifies whether aggregated by time. If isAggregateByTime is true, all usage carbon emissions over the query time period will be added up.


        :param is_aggregate_by_time: The is_aggregate_by_time of this RequestUsageCarbonEmissionsDetails.
        :type: bool
        """
        self._is_aggregate_by_time = is_aggregate_by_time

    @property
    def group_by(self):
        """
        Gets the group_by of this RequestUsageCarbonEmissionsDetails.
        Aggregate the result by.
        For example:
          `[\"tagNamespace\", \"tagKey\", \"tagValue\", \"service\", \"skuName\", \"skuPartNumber\", \"unit\",
            \"compartmentName\", \"compartmentPath\", \"compartmentId\", \"platform\", \"region\", \"logicalAd\",
            \"resourceId\", \"resourceName\", \"tenantId\", \"tenantName\", \"subscriptionId\"]`


        :return: The group_by of this RequestUsageCarbonEmissionsDetails.
        :rtype: list[str]
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """
        Sets the group_by of this RequestUsageCarbonEmissionsDetails.
        Aggregate the result by.
        For example:
          `[\"tagNamespace\", \"tagKey\", \"tagValue\", \"service\", \"skuName\", \"skuPartNumber\", \"unit\",
            \"compartmentName\", \"compartmentPath\", \"compartmentId\", \"platform\", \"region\", \"logicalAd\",
            \"resourceId\", \"resourceName\", \"tenantId\", \"tenantName\", \"subscriptionId\"]`


        :param group_by: The group_by of this RequestUsageCarbonEmissionsDetails.
        :type: list[str]
        """
        self._group_by = group_by

    @property
    def group_by_tag(self):
        """
        Gets the group_by_tag of this RequestUsageCarbonEmissionsDetails.
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list.
        For example:
          `[{\"namespace\":\"oracle\", \"key\":\"createdBy\"]`


        :return: The group_by_tag of this RequestUsageCarbonEmissionsDetails.
        :rtype: list[oci.usage_api.models.Tag]
        """
        return self._group_by_tag

    @group_by_tag.setter
    def group_by_tag(self, group_by_tag):
        """
        Sets the group_by_tag of this RequestUsageCarbonEmissionsDetails.
        GroupBy a specific tagKey. Provide the tagNamespace and tagKey in the tag object. Only supports one tag in the list.
        For example:
          `[{\"namespace\":\"oracle\", \"key\":\"createdBy\"]`


        :param group_by_tag: The group_by_tag of this RequestUsageCarbonEmissionsDetails.
        :type: list[oci.usage_api.models.Tag]
        """
        self._group_by_tag = group_by_tag

    @property
    def compartment_depth(self):
        """
        Gets the compartment_depth of this RequestUsageCarbonEmissionsDetails.
        The compartment depth level.


        :return: The compartment_depth of this RequestUsageCarbonEmissionsDetails.
        :rtype: int
        """
        return self._compartment_depth

    @compartment_depth.setter
    def compartment_depth(self, compartment_depth):
        """
        Sets the compartment_depth of this RequestUsageCarbonEmissionsDetails.
        The compartment depth level.


        :param compartment_depth: The compartment_depth of this RequestUsageCarbonEmissionsDetails.
        :type: int
        """
        self._compartment_depth = compartment_depth

    @property
    def filter(self):
        """
        Gets the filter of this RequestUsageCarbonEmissionsDetails.

        :return: The filter of this RequestUsageCarbonEmissionsDetails.
        :rtype: oci.usage_api.models.Filter
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """
        Sets the filter of this RequestUsageCarbonEmissionsDetails.

        :param filter: The filter of this RequestUsageCarbonEmissionsDetails.
        :type: oci.usage_api.models.Filter
        """
        self._filter = filter

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
