# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityImpactedContainerSummary(object):
    """
    Information on a container image impacted by a vulnerability
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityImpactedContainerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param container_scan_target_id:
            The value to assign to the container_scan_target_id property of this VulnerabilityImpactedContainerSummary.
        :type container_scan_target_id: str

        :param repository:
            The value to assign to the repository property of this VulnerabilityImpactedContainerSummary.
        :type repository: str

        :param registry:
            The value to assign to the registry property of this VulnerabilityImpactedContainerSummary.
        :type registry: str

        :param image:
            The value to assign to the image property of this VulnerabilityImpactedContainerSummary.
        :type image: str

        :param last_container_scan_id:
            The value to assign to the last_container_scan_id property of this VulnerabilityImpactedContainerSummary.
        :type last_container_scan_id: str

        :param time_scan_completed:
            The value to assign to the time_scan_completed property of this VulnerabilityImpactedContainerSummary.
        :type time_scan_completed: datetime

        """
        self.swagger_types = {
            'container_scan_target_id': 'str',
            'repository': 'str',
            'registry': 'str',
            'image': 'str',
            'last_container_scan_id': 'str',
            'time_scan_completed': 'datetime'
        }

        self.attribute_map = {
            'container_scan_target_id': 'containerScanTargetId',
            'repository': 'repository',
            'registry': 'registry',
            'image': 'image',
            'last_container_scan_id': 'lastContainerScanId',
            'time_scan_completed': 'timeScanCompleted'
        }

        self._container_scan_target_id = None
        self._repository = None
        self._registry = None
        self._image = None
        self._last_container_scan_id = None
        self._time_scan_completed = None

    @property
    def container_scan_target_id(self):
        """
        **[Required]** Gets the container_scan_target_id of this VulnerabilityImpactedContainerSummary.
        The scan target id of the repository scan result


        :return: The container_scan_target_id of this VulnerabilityImpactedContainerSummary.
        :rtype: str
        """
        return self._container_scan_target_id

    @container_scan_target_id.setter
    def container_scan_target_id(self, container_scan_target_id):
        """
        Sets the container_scan_target_id of this VulnerabilityImpactedContainerSummary.
        The scan target id of the repository scan result


        :param container_scan_target_id: The container_scan_target_id of this VulnerabilityImpactedContainerSummary.
        :type: str
        """
        self._container_scan_target_id = container_scan_target_id

    @property
    def repository(self):
        """
        **[Required]** Gets the repository of this VulnerabilityImpactedContainerSummary.
        The repository id of the container image.


        :return: The repository of this VulnerabilityImpactedContainerSummary.
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """
        Sets the repository of this VulnerabilityImpactedContainerSummary.
        The repository id of the container image.


        :param repository: The repository of this VulnerabilityImpactedContainerSummary.
        :type: str
        """
        self._repository = repository

    @property
    def registry(self):
        """
        **[Required]** Gets the registry of this VulnerabilityImpactedContainerSummary.
        The registry key of the container image.


        :return: The registry of this VulnerabilityImpactedContainerSummary.
        :rtype: str
        """
        return self._registry

    @registry.setter
    def registry(self, registry):
        """
        Sets the registry of this VulnerabilityImpactedContainerSummary.
        The registry key of the container image.


        :param registry: The registry of this VulnerabilityImpactedContainerSummary.
        :type: str
        """
        self._registry = registry

    @property
    def image(self):
        """
        **[Required]** Gets the image of this VulnerabilityImpactedContainerSummary.
        The name of the container image.


        :return: The image of this VulnerabilityImpactedContainerSummary.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this VulnerabilityImpactedContainerSummary.
        The name of the container image.


        :param image: The image of this VulnerabilityImpactedContainerSummary.
        :type: str
        """
        self._image = image

    @property
    def last_container_scan_id(self):
        """
        **[Required]** Gets the last_container_scan_id of this VulnerabilityImpactedContainerSummary.
        The ID of the last container image scan result Id


        :return: The last_container_scan_id of this VulnerabilityImpactedContainerSummary.
        :rtype: str
        """
        return self._last_container_scan_id

    @last_container_scan_id.setter
    def last_container_scan_id(self, last_container_scan_id):
        """
        Sets the last_container_scan_id of this VulnerabilityImpactedContainerSummary.
        The ID of the last container image scan result Id


        :param last_container_scan_id: The last_container_scan_id of this VulnerabilityImpactedContainerSummary.
        :type: str
        """
        self._last_container_scan_id = last_container_scan_id

    @property
    def time_scan_completed(self):
        """
        **[Required]** Gets the time_scan_completed of this VulnerabilityImpactedContainerSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_scan_completed of this VulnerabilityImpactedContainerSummary.
        :rtype: datetime
        """
        return self._time_scan_completed

    @time_scan_completed.setter
    def time_scan_completed(self, time_scan_completed):
        """
        Sets the time_scan_completed of this VulnerabilityImpactedContainerSummary.
        Date and time the scan was completed, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_scan_completed: The time_scan_completed of this VulnerabilityImpactedContainerSummary.
        :type: datetime
        """
        self._time_scan_completed = time_scan_completed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
