# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestProperties(object):
    """
    Pull request properties from recommend stage of the remediation run.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pull_request_identifier:
            The value to assign to the pull_request_identifier property of this PullRequestProperties.
        :type pull_request_identifier: str

        :param pull_request_url:
            The value to assign to the pull_request_url property of this PullRequestProperties.
        :type pull_request_url: str

        """
        self.swagger_types = {
            'pull_request_identifier': 'str',
            'pull_request_url': 'str'
        }

        self.attribute_map = {
            'pull_request_identifier': 'pullRequestIdentifier',
            'pull_request_url': 'pullRequestUrl'
        }

        self._pull_request_identifier = None
        self._pull_request_url = None

    @property
    def pull_request_identifier(self):
        """
        Gets the pull_request_identifier of this PullRequestProperties.
        Unique identifier for the pull or merge request created in the recommend stage.


        :return: The pull_request_identifier of this PullRequestProperties.
        :rtype: str
        """
        return self._pull_request_identifier

    @pull_request_identifier.setter
    def pull_request_identifier(self, pull_request_identifier):
        """
        Sets the pull_request_identifier of this PullRequestProperties.
        Unique identifier for the pull or merge request created in the recommend stage.


        :param pull_request_identifier: The pull_request_identifier of this PullRequestProperties.
        :type: str
        """
        self._pull_request_identifier = pull_request_identifier

    @property
    def pull_request_url(self):
        """
        Gets the pull_request_url of this PullRequestProperties.
        The web link to the pull or merge request created in the recommend stage.


        :return: The pull_request_url of this PullRequestProperties.
        :rtype: str
        """
        return self._pull_request_url

    @pull_request_url.setter
    def pull_request_url(self, pull_request_url):
        """
        Sets the pull_request_url of this PullRequestProperties.
        The web link to the pull or merge request created in the recommend stage.


        :param pull_request_url: The pull_request_url of this PullRequestProperties.
        :type: str
        """
        self._pull_request_url = pull_request_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
