# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdateNotesStatus(object):
    """
    Response of a bulk update notes operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdateNotesStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_statuses:
            The value to assign to the attribute_statuses property of this BulkUpdateNotesStatus.
        :type attribute_statuses: list[oci.apm_traces.models.AttributeUpdateNotesResponse]

        :param bulk_update_notes_metadata:
            The value to assign to the bulk_update_notes_metadata property of this BulkUpdateNotesStatus.
        :type bulk_update_notes_metadata: oci.apm_traces.models.BulkUpdateNotesMetadata

        """
        self.swagger_types = {
            'attribute_statuses': 'list[AttributeUpdateNotesResponse]',
            'bulk_update_notes_metadata': 'BulkUpdateNotesMetadata'
        }

        self.attribute_map = {
            'attribute_statuses': 'attributeStatuses',
            'bulk_update_notes_metadata': 'bulkUpdateNotesMetadata'
        }

        self._attribute_statuses = None
        self._bulk_update_notes_metadata = None

    @property
    def attribute_statuses(self):
        """
        **[Required]** Gets the attribute_statuses of this BulkUpdateNotesStatus.
        We preserve the order of the attribute items from the bulk update notes request in this collection.  The ith object in this collection represents the
        bulk update notes operation status of the ith object in the BulkUpdateAttributeNotesDetails object in the Bulk update notes request.  If the
        bulk update notes operation results in a processing error or a validation error, the operationStatus property in the  BulkUpdateNotesMetadata object will
        contain the appropriate bulk error status for the bulk operation.


        :return: The attribute_statuses of this BulkUpdateNotesStatus.
        :rtype: list[oci.apm_traces.models.AttributeUpdateNotesResponse]
        """
        return self._attribute_statuses

    @attribute_statuses.setter
    def attribute_statuses(self, attribute_statuses):
        """
        Sets the attribute_statuses of this BulkUpdateNotesStatus.
        We preserve the order of the attribute items from the bulk update notes request in this collection.  The ith object in this collection represents the
        bulk update notes operation status of the ith object in the BulkUpdateAttributeNotesDetails object in the Bulk update notes request.  If the
        bulk update notes operation results in a processing error or a validation error, the operationStatus property in the  BulkUpdateNotesMetadata object will
        contain the appropriate bulk error status for the bulk operation.


        :param attribute_statuses: The attribute_statuses of this BulkUpdateNotesStatus.
        :type: list[oci.apm_traces.models.AttributeUpdateNotesResponse]
        """
        self._attribute_statuses = attribute_statuses

    @property
    def bulk_update_notes_metadata(self):
        """
        **[Required]** Gets the bulk_update_notes_metadata of this BulkUpdateNotesStatus.

        :return: The bulk_update_notes_metadata of this BulkUpdateNotesStatus.
        :rtype: oci.apm_traces.models.BulkUpdateNotesMetadata
        """
        return self._bulk_update_notes_metadata

    @bulk_update_notes_metadata.setter
    def bulk_update_notes_metadata(self, bulk_update_notes_metadata):
        """
        Sets the bulk_update_notes_metadata of this BulkUpdateNotesStatus.

        :param bulk_update_notes_metadata: The bulk_update_notes_metadata of this BulkUpdateNotesStatus.
        :type: oci.apm_traces.models.BulkUpdateNotesMetadata
        """
        self._bulk_update_notes_metadata = bulk_update_notes_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
