# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107

from .occ_capacity_request_base_details import OccCapacityRequestBaseDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccCapacityRequestComputeDetails(OccCapacityRequestBaseDetails):
    """
    The details about the compute servers required for creating a capacity request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccCapacityRequestComputeDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.capacity_management.models.OccCapacityRequestComputeDetails.resource_type` attribute
        of this class is ``SERVER_HW`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_type:
            The value to assign to the resource_type property of this OccCapacityRequestComputeDetails.
            Allowed values for this property are: "SERVER_HW"
        :type resource_type: str

        :param workload_type:
            The value to assign to the workload_type property of this OccCapacityRequestComputeDetails.
        :type workload_type: str

        :param expected_handover_quantity:
            The value to assign to the expected_handover_quantity property of this OccCapacityRequestComputeDetails.
        :type expected_handover_quantity: int

        :param date_expected_handover:
            The value to assign to the date_expected_handover property of this OccCapacityRequestComputeDetails.
        :type date_expected_handover: datetime

        :param actual_handover_quantity:
            The value to assign to the actual_handover_quantity property of this OccCapacityRequestComputeDetails.
        :type actual_handover_quantity: int

        :param date_actual_handover:
            The value to assign to the date_actual_handover property of this OccCapacityRequestComputeDetails.
        :type date_actual_handover: datetime

        :param resource_name:
            The value to assign to the resource_name property of this OccCapacityRequestComputeDetails.
        :type resource_name: str

        :param demand_quantity:
            The value to assign to the demand_quantity property of this OccCapacityRequestComputeDetails.
        :type demand_quantity: int

        """
        self.swagger_types = {
            'resource_type': 'str',
            'workload_type': 'str',
            'expected_handover_quantity': 'int',
            'date_expected_handover': 'datetime',
            'actual_handover_quantity': 'int',
            'date_actual_handover': 'datetime',
            'resource_name': 'str',
            'demand_quantity': 'int'
        }

        self.attribute_map = {
            'resource_type': 'resourceType',
            'workload_type': 'workloadType',
            'expected_handover_quantity': 'expectedHandoverQuantity',
            'date_expected_handover': 'dateExpectedHandover',
            'actual_handover_quantity': 'actualHandoverQuantity',
            'date_actual_handover': 'dateActualHandover',
            'resource_name': 'resourceName',
            'demand_quantity': 'demandQuantity'
        }

        self._resource_type = None
        self._workload_type = None
        self._expected_handover_quantity = None
        self._date_expected_handover = None
        self._actual_handover_quantity = None
        self._date_actual_handover = None
        self._resource_name = None
        self._demand_quantity = None
        self._resource_type = 'SERVER_HW'

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this OccCapacityRequestComputeDetails.
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.


        :return: The resource_name of this OccCapacityRequestComputeDetails.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this OccCapacityRequestComputeDetails.
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.


        :param resource_name: The resource_name of this OccCapacityRequestComputeDetails.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def demand_quantity(self):
        """
        **[Required]** Gets the demand_quantity of this OccCapacityRequestComputeDetails.
        The number of compute server's with name <resourceName> required by the user.


        :return: The demand_quantity of this OccCapacityRequestComputeDetails.
        :rtype: int
        """
        return self._demand_quantity

    @demand_quantity.setter
    def demand_quantity(self, demand_quantity):
        """
        Sets the demand_quantity of this OccCapacityRequestComputeDetails.
        The number of compute server's with name <resourceName> required by the user.


        :param demand_quantity: The demand_quantity of this OccCapacityRequestComputeDetails.
        :type: int
        """
        self._demand_quantity = demand_quantity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
