# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryResourceSummary(object):
    """
    Lists resources and its properties under a given subnet.
    """

    #: A constant which can be used with the resource_type property of a InventoryResourceSummary.
    #: This constant has a value of "Resource"
    RESOURCE_TYPE_RESOURCE = "Resource"

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_name:
            The value to assign to the resource_name property of this InventoryResourceSummary.
        :type resource_name: str

        :param resource_type:
            The value to assign to the resource_type property of this InventoryResourceSummary.
            Allowed values for this property are: "Resource", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param ip_address_collection:
            The value to assign to the ip_address_collection property of this InventoryResourceSummary.
        :type ip_address_collection: list[oci.core.models.InventoryIpAddressSummary]

        :param region:
            The value to assign to the region property of this InventoryResourceSummary.
        :type region: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InventoryResourceSummary.
        :type compartment_id: str

        """
        self.swagger_types = {
            'resource_name': 'str',
            'resource_type': 'str',
            'ip_address_collection': 'list[InventoryIpAddressSummary]',
            'region': 'str',
            'compartment_id': 'str'
        }

        self.attribute_map = {
            'resource_name': 'resourceName',
            'resource_type': 'resourceType',
            'ip_address_collection': 'ipAddressCollection',
            'region': 'region',
            'compartment_id': 'compartmentId'
        }

        self._resource_name = None
        self._resource_type = None
        self._ip_address_collection = None
        self._region = None
        self._compartment_id = None

    @property
    def resource_name(self):
        """
        Gets the resource_name of this InventoryResourceSummary.
        The name of the resource created.


        :return: The resource_name of this InventoryResourceSummary.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this InventoryResourceSummary.
        The name of the resource created.


        :param resource_name: The resource_name of this InventoryResourceSummary.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_type(self):
        """
        Gets the resource_type of this InventoryResourceSummary.
        Resource types of the resource.

        Allowed values for this property are: "Resource", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_type of this InventoryResourceSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this InventoryResourceSummary.
        Resource types of the resource.


        :param resource_type: The resource_type of this InventoryResourceSummary.
        :type: str
        """
        allowed_values = ["Resource"]
        if not value_allowed_none_or_none_sentinel(resource_type, allowed_values):
            resource_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_type = resource_type

    @property
    def ip_address_collection(self):
        """
        Gets the ip_address_collection of this InventoryResourceSummary.
        Lists the 'IpAddressCollection' object.


        :return: The ip_address_collection of this InventoryResourceSummary.
        :rtype: list[oci.core.models.InventoryIpAddressSummary]
        """
        return self._ip_address_collection

    @ip_address_collection.setter
    def ip_address_collection(self, ip_address_collection):
        """
        Sets the ip_address_collection of this InventoryResourceSummary.
        Lists the 'IpAddressCollection' object.


        :param ip_address_collection: The ip_address_collection of this InventoryResourceSummary.
        :type: list[oci.core.models.InventoryIpAddressSummary]
        """
        self._ip_address_collection = ip_address_collection

    @property
    def region(self):
        """
        Gets the region of this InventoryResourceSummary.
        The region name of the corresponding resource.


        :return: The region of this InventoryResourceSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this InventoryResourceSummary.
        The region name of the corresponding resource.


        :param region: The region of this InventoryResourceSummary.
        :type: str
        """
        self._region = region

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this InventoryResourceSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this InventoryResourceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InventoryResourceSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this InventoryResourceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
