# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .format_entry import FormatEntry
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatternFormatEntry(FormatEntry):
    """
    The Pattern masking format randomly selects values according to pattern
    to replace the original values.
    Rules
    Max Generated Data Length 30 characters
    Use '%c' for a random lowercase letter
    Use '%C' for a random uppercase letter
    Use '%u[]' for a random character out of all characters enclosed in []
    Use '%%' for a '%'
    Use '%d' for a random digit
    Use '%nd','%nc', '%nC', or '%nu[]' n random letters or digits or characters enclosed in [], n can be 0-9 only
    Any other character will be included as it is
    Examples
    %3d-%5C will generate 416-JQPCS
    %3d-%5c will generate 392-dehco
    %u[$^#] will generate $
    %%%3d will generate %704
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatternFormatEntry object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.PatternFormatEntry.type` attribute
        of this class is ``PATTERN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this PatternFormatEntry.
            Allowed values for this property are: "DELETE_ROWS", "DETERMINISTIC_SUBSTITUTION", "DETERMINISTIC_ENCRYPTION", "DETERMINISTIC_ENCRYPTION_DATE", "FIXED_NUMBER", "FIXED_STRING", "LIBRARY_MASKING_FORMAT", "NULL_VALUE", "PATTERN", "POST_PROCESSING_FUNCTION", "PRESERVE_ORIGINAL_DATA", "RANDOM_DATE", "RANDOM_DECIMAL_NUMBER", "RANDOM_DIGITS", "RANDOM_LIST", "RANDOM_NUMBER", "RANDOM_STRING", "RANDOM_SUBSTITUTION", "REGULAR_EXPRESSION", "SHUFFLE", "SQL_EXPRESSION", "SUBSTRING", "TRUNCATE_TABLE", "USER_DEFINED_FUNCTION"
        :type type: str

        :param description:
            The value to assign to the description property of this PatternFormatEntry.
        :type description: str

        :param pattern:
            The value to assign to the pattern property of this PatternFormatEntry.
        :type pattern: str

        """
        self.swagger_types = {
            'type': 'str',
            'description': 'str',
            'pattern': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'description': 'description',
            'pattern': 'pattern'
        }

        self._type = None
        self._description = None
        self._pattern = None
        self._type = 'PATTERN'

    @property
    def pattern(self):
        """
        **[Required]** Gets the pattern of this PatternFormatEntry.
        The pattern that should be used to mask data.


        :return: The pattern of this PatternFormatEntry.
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """
        Sets the pattern of this PatternFormatEntry.
        The pattern that should be used to mask data.


        :param pattern: The pattern of this PatternFormatEntry.
        :type: str
        """
        self._pattern = pattern

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
