# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityPolicyEntryStateSummary(object):
    """
    The resource represents the state of a specific entry type deployment on a target.
    """

    #: A constant which can be used with the deployment_status property of a SecurityPolicyEntryStateSummary.
    #: This constant has a value of "CREATED"
    DEPLOYMENT_STATUS_CREATED = "CREATED"

    #: A constant which can be used with the deployment_status property of a SecurityPolicyEntryStateSummary.
    #: This constant has a value of "MODIFIED"
    DEPLOYMENT_STATUS_MODIFIED = "MODIFIED"

    #: A constant which can be used with the deployment_status property of a SecurityPolicyEntryStateSummary.
    #: This constant has a value of "CONFLICT"
    DEPLOYMENT_STATUS_CONFLICT = "CONFLICT"

    #: A constant which can be used with the deployment_status property of a SecurityPolicyEntryStateSummary.
    #: This constant has a value of "UNAUTHORIZED"
    DEPLOYMENT_STATUS_UNAUTHORIZED = "UNAUTHORIZED"

    #: A constant which can be used with the deployment_status property of a SecurityPolicyEntryStateSummary.
    #: This constant has a value of "DELETED"
    DEPLOYMENT_STATUS_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityPolicyEntryStateSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SecurityPolicyEntryStateSummary.
        :type id: str

        :param security_policy_entry_id:
            The value to assign to the security_policy_entry_id property of this SecurityPolicyEntryStateSummary.
        :type security_policy_entry_id: str

        :param security_policy_deployment_id:
            The value to assign to the security_policy_deployment_id property of this SecurityPolicyEntryStateSummary.
        :type security_policy_deployment_id: str

        :param deployment_status:
            The value to assign to the deployment_status property of this SecurityPolicyEntryStateSummary.
            Allowed values for this property are: "CREATED", "MODIFIED", "CONFLICT", "UNAUTHORIZED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_status: str

        """
        self.swagger_types = {
            'id': 'str',
            'security_policy_entry_id': 'str',
            'security_policy_deployment_id': 'str',
            'deployment_status': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'security_policy_entry_id': 'securityPolicyEntryId',
            'security_policy_deployment_id': 'securityPolicyDeploymentId',
            'deployment_status': 'deploymentStatus'
        }

        self._id = None
        self._security_policy_entry_id = None
        self._security_policy_deployment_id = None
        self._deployment_status = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SecurityPolicyEntryStateSummary.
        Unique id of the security policy entry state.


        :return: The id of this SecurityPolicyEntryStateSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SecurityPolicyEntryStateSummary.
        Unique id of the security policy entry state.


        :param id: The id of this SecurityPolicyEntryStateSummary.
        :type: str
        """
        self._id = id

    @property
    def security_policy_entry_id(self):
        """
        **[Required]** Gets the security_policy_entry_id of this SecurityPolicyEntryStateSummary.
        The OCID of the security policy entry associated.


        :return: The security_policy_entry_id of this SecurityPolicyEntryStateSummary.
        :rtype: str
        """
        return self._security_policy_entry_id

    @security_policy_entry_id.setter
    def security_policy_entry_id(self, security_policy_entry_id):
        """
        Sets the security_policy_entry_id of this SecurityPolicyEntryStateSummary.
        The OCID of the security policy entry associated.


        :param security_policy_entry_id: The security_policy_entry_id of this SecurityPolicyEntryStateSummary.
        :type: str
        """
        self._security_policy_entry_id = security_policy_entry_id

    @property
    def security_policy_deployment_id(self):
        """
        Gets the security_policy_deployment_id of this SecurityPolicyEntryStateSummary.
        The OCID of the security policy deployment associated.


        :return: The security_policy_deployment_id of this SecurityPolicyEntryStateSummary.
        :rtype: str
        """
        return self._security_policy_deployment_id

    @security_policy_deployment_id.setter
    def security_policy_deployment_id(self, security_policy_deployment_id):
        """
        Sets the security_policy_deployment_id of this SecurityPolicyEntryStateSummary.
        The OCID of the security policy deployment associated.


        :param security_policy_deployment_id: The security_policy_deployment_id of this SecurityPolicyEntryStateSummary.
        :type: str
        """
        self._security_policy_deployment_id = security_policy_deployment_id

    @property
    def deployment_status(self):
        """
        **[Required]** Gets the deployment_status of this SecurityPolicyEntryStateSummary.
        The current deployment status of the security policy deployment and the security policy entry associated.

        Allowed values for this property are: "CREATED", "MODIFIED", "CONFLICT", "UNAUTHORIZED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_status of this SecurityPolicyEntryStateSummary.
        :rtype: str
        """
        return self._deployment_status

    @deployment_status.setter
    def deployment_status(self, deployment_status):
        """
        Sets the deployment_status of this SecurityPolicyEntryStateSummary.
        The current deployment status of the security policy deployment and the security policy entry associated.


        :param deployment_status: The deployment_status of this SecurityPolicyEntryStateSummary.
        :type: str
        """
        allowed_values = ["CREATED", "MODIFIED", "CONFLICT", "UNAUTHORIZED", "DELETED"]
        if not value_allowed_none_or_none_sentinel(deployment_status, allowed_values):
            deployment_status = 'UNKNOWN_ENUM_VALUE'
        self._deployment_status = deployment_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
