# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDataSciencePrivateEndpointDetails(object):
    """
    The details required to create a Data Science private endpoint.
    """

    #: A constant which can be used with the data_science_resource_type property of a CreateDataSciencePrivateEndpointDetails.
    #: This constant has a value of "NOTEBOOK_SESSION"
    DATA_SCIENCE_RESOURCE_TYPE_NOTEBOOK_SESSION = "NOTEBOOK_SESSION"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDataSciencePrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDataSciencePrivateEndpointDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateDataSciencePrivateEndpointDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CreateDataSciencePrivateEndpointDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDataSciencePrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDataSciencePrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateDataSciencePrivateEndpointDetails.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateDataSciencePrivateEndpointDetails.
        :type subnet_id: str

        :param sub_domain:
            The value to assign to the sub_domain property of this CreateDataSciencePrivateEndpointDetails.
        :type sub_domain: str

        :param data_science_resource_type:
            The value to assign to the data_science_resource_type property of this CreateDataSciencePrivateEndpointDetails.
            Allowed values for this property are: "NOTEBOOK_SESSION"
        :type data_science_resource_type: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'sub_domain': 'str',
            'data_science_resource_type': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'sub_domain': 'subDomain',
            'data_science_resource_type': 'dataScienceResourceType'
        }

        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._nsg_ids = None
        self._subnet_id = None
        self._sub_domain = None
        self._data_science_resource_type = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDataSciencePrivateEndpointDetails.
        The `OCID`__ of the compartment where you want to create the private endpoint.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDataSciencePrivateEndpointDetails.
        The `OCID`__ of the compartment where you want to create the private endpoint.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateDataSciencePrivateEndpointDetails.
        A user friendly description. Avoid entering confidential information.


        :return: The description of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDataSciencePrivateEndpointDetails.
        A user friendly description. Avoid entering confidential information.


        :param description: The description of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDataSciencePrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :return: The display_name of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDataSciencePrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDataSciencePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDataSciencePrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDataSciencePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDataSciencePrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDataSciencePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDataSciencePrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDataSciencePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDataSciencePrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateDataSciencePrivateEndpointDetails.
        An array of network security group OCIDs.


        :return: The nsg_ids of this CreateDataSciencePrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateDataSciencePrivateEndpointDetails.
        An array of network security group OCIDs.


        :param nsg_ids: The nsg_ids of this CreateDataSciencePrivateEndpointDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateDataSciencePrivateEndpointDetails.
        The OCID of the subnet.


        :return: The subnet_id of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateDataSciencePrivateEndpointDetails.
        The OCID of the subnet.


        :param subnet_id: The subnet_id of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def sub_domain(self):
        """
        Gets the sub_domain of this CreateDataSciencePrivateEndpointDetails.
        Subdomain for a private endpoint FQDN.


        :return: The sub_domain of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._sub_domain

    @sub_domain.setter
    def sub_domain(self, sub_domain):
        """
        Sets the sub_domain of this CreateDataSciencePrivateEndpointDetails.
        Subdomain for a private endpoint FQDN.


        :param sub_domain: The sub_domain of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        self._sub_domain = sub_domain

    @property
    def data_science_resource_type(self):
        """
        **[Required]** Gets the data_science_resource_type of this CreateDataSciencePrivateEndpointDetails.
        Data Science resource type.

        Allowed values for this property are: "NOTEBOOK_SESSION"


        :return: The data_science_resource_type of this CreateDataSciencePrivateEndpointDetails.
        :rtype: str
        """
        return self._data_science_resource_type

    @data_science_resource_type.setter
    def data_science_resource_type(self, data_science_resource_type):
        """
        Sets the data_science_resource_type of this CreateDataSciencePrivateEndpointDetails.
        Data Science resource type.


        :param data_science_resource_type: The data_science_resource_type of this CreateDataSciencePrivateEndpointDetails.
        :type: str
        """
        allowed_values = ["NOTEBOOK_SESSION"]
        if not value_allowed_none_or_none_sentinel(data_science_resource_type, allowed_values):
            raise ValueError(
                f"Invalid value for `data_science_resource_type`, must be None or one of {allowed_values}"
            )
        self._data_science_resource_type = data_science_resource_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
