# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .connector_details import ConnectorDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalConnectorDetails(ConnectorDetails):
    """
    The details of the external database connector used to connect to the external database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalConnectorDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.ExternalConnectorDetails.connector_type` attribute
        of this class is ``EXTERNAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_type:
            The value to assign to the connector_type property of this ExternalConnectorDetails.
            Allowed values for this property are: "PE", "MACS", "EXTERNAL"
        :type connector_type: str

        :param database_connector_id:
            The value to assign to the database_connector_id property of this ExternalConnectorDetails.
        :type database_connector_id: str

        """
        self.swagger_types = {
            'connector_type': 'str',
            'database_connector_id': 'str'
        }

        self.attribute_map = {
            'connector_type': 'connectorType',
            'database_connector_id': 'databaseConnectorId'
        }

        self._connector_type = None
        self._database_connector_id = None
        self._connector_type = 'EXTERNAL'

    @property
    def database_connector_id(self):
        """
        **[Required]** Gets the database_connector_id of this ExternalConnectorDetails.
        The `OCID`__ of the external database connector.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_connector_id of this ExternalConnectorDetails.
        :rtype: str
        """
        return self._database_connector_id

    @database_connector_id.setter
    def database_connector_id(self, database_connector_id):
        """
        Sets the database_connector_id of this ExternalConnectorDetails.
        The `OCID`__ of the external database connector.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_connector_id: The database_connector_id of this ExternalConnectorDetails.
        :type: str
        """
        self._database_connector_id = database_connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
