# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOccDemandSignalDetails(object):
    """
    The data to create a OccDemandSignal.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOccDemandSignalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateOccDemandSignalDetails.
        :type display_name: str

        :param occ_demand_signals:
            The value to assign to the occ_demand_signals property of this CreateOccDemandSignalDetails.
        :type occ_demand_signals: list[oci.demand_signal.models.OccDemandSignalData]

        :param is_active:
            The value to assign to the is_active property of this CreateOccDemandSignalDetails.
        :type is_active: bool

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOccDemandSignalDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOccDemandSignalDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOccDemandSignalDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'occ_demand_signals': 'list[OccDemandSignalData]',
            'is_active': 'bool',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'occ_demand_signals': 'occDemandSignals',
            'is_active': 'isActive',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._occ_demand_signals = None
        self._is_active = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateOccDemandSignalDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateOccDemandSignalDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOccDemandSignalDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateOccDemandSignalDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def occ_demand_signals(self):
        """
        **[Required]** Gets the occ_demand_signals of this CreateOccDemandSignalDetails.
        The OccDemandSignal data.


        :return: The occ_demand_signals of this CreateOccDemandSignalDetails.
        :rtype: list[oci.demand_signal.models.OccDemandSignalData]
        """
        return self._occ_demand_signals

    @occ_demand_signals.setter
    def occ_demand_signals(self, occ_demand_signals):
        """
        Sets the occ_demand_signals of this CreateOccDemandSignalDetails.
        The OccDemandSignal data.


        :param occ_demand_signals: The occ_demand_signals of this CreateOccDemandSignalDetails.
        :type: list[oci.demand_signal.models.OccDemandSignalData]
        """
        self._occ_demand_signals = occ_demand_signals

    @property
    def is_active(self):
        """
        **[Required]** Gets the is_active of this CreateOccDemandSignalDetails.
        Indicator of whether to share the data with Oracle.


        :return: The is_active of this CreateOccDemandSignalDetails.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """
        Sets the is_active of this CreateOccDemandSignalDetails.
        Indicator of whether to share the data with Oracle.


        :param is_active: The is_active of this CreateOccDemandSignalDetails.
        :type: bool
        """
        self._is_active = is_active

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOccDemandSignalDetails.
        The `OCID`__ of the compartment to create the OccDemandSignal in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateOccDemandSignalDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOccDemandSignalDetails.
        The `OCID`__ of the compartment to create the OccDemandSignal in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateOccDemandSignalDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOccDemandSignalDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateOccDemandSignalDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOccDemandSignalDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateOccDemandSignalDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOccDemandSignalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateOccDemandSignalDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOccDemandSignalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateOccDemandSignalDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
