# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFileSystemDetails(object):
    """
    Details for updating the file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateFileSystemDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param kms_key_id:
            The value to assign to the kms_key_id property of this UpdateFileSystemDetails.
        :type kms_key_id: str

        :param filesystem_snapshot_policy_id:
            The value to assign to the filesystem_snapshot_policy_id property of this UpdateFileSystemDetails.
        :type filesystem_snapshot_policy_id: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'kms_key_id': 'str',
            'filesystem_snapshot_policy_id': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'kms_key_id': 'kmsKeyId',
            'filesystem_snapshot_policy_id': 'filesystemSnapshotPolicyId'
        }

        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._kms_key_id = None
        self._filesystem_snapshot_policy_id = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My file system`


        :return: The display_name of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateFileSystemDetails.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My file system`


        :param display_name: The display_name of this UpdateFileSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair
         with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair
         with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this UpdateFileSystemDetails.
        The `OCID`__ of the Key Management master encryption key to associate with the specified file system.
        If this value is empty, the Update operation will remove the associated key, if there is one, from the file system.
        (The file system will continue to be encrypted, but with an encryption key managed by Oracle.)

        If updating to a new Key Management key, the old key must remain enabled so that files previously encrypted continue
        to be accessible. For more information, see `Overview of Key Management`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm


        :return: The kms_key_id of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this UpdateFileSystemDetails.
        The `OCID`__ of the Key Management master encryption key to associate with the specified file system.
        If this value is empty, the Update operation will remove the associated key, if there is one, from the file system.
        (The file system will continue to be encrypted, but with an encryption key managed by Oracle.)

        If updating to a new Key Management key, the old key must remain enabled so that files previously encrypted continue
        to be accessible. For more information, see `Overview of Key Management`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm


        :param kms_key_id: The kms_key_id of this UpdateFileSystemDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def filesystem_snapshot_policy_id(self):
        """
        Gets the filesystem_snapshot_policy_id of this UpdateFileSystemDetails.
        The `OCID`__ of the associated file system snapshot policy, which
        controls the frequency of snapshot creation and retention period of the taken snapshots.

        If string is empty, the policy reference (if any) would be removed.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The filesystem_snapshot_policy_id of this UpdateFileSystemDetails.
        :rtype: str
        """
        return self._filesystem_snapshot_policy_id

    @filesystem_snapshot_policy_id.setter
    def filesystem_snapshot_policy_id(self, filesystem_snapshot_policy_id):
        """
        Sets the filesystem_snapshot_policy_id of this UpdateFileSystemDetails.
        The `OCID`__ of the associated file system snapshot policy, which
        controls the frequency of snapshot creation and retention period of the taken snapshots.

        If string is empty, the policy reference (if any) would be removed.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param filesystem_snapshot_policy_id: The filesystem_snapshot_policy_id of this UpdateFileSystemDetails.
        :type: str
        """
        self._filesystem_snapshot_policy_id = filesystem_snapshot_policy_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
