# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DiscoveryDetails(object):
    """
    Discovery filter details for search.
    """

    #: A constant which can be used with the type property of a DiscoveryDetails.
    #: This constant has a value of "DB"
    TYPE_DB = "DB"

    #: A constant which can be used with the type property of a DiscoveryDetails.
    #: This constant has a value of "GI"
    TYPE_GI = "GI"

    #: A constant which can be used with the service_type property of a DiscoveryDetails.
    #: This constant has a value of "EXACS"
    SERVICE_TYPE_EXACS = "EXACS"

    #: A constant which can be used with the service_type property of a DiscoveryDetails.
    #: This constant has a value of "EXACC"
    SERVICE_TYPE_EXACC = "EXACC"

    def __init__(self, **kwargs):
        """
        Initializes a new DiscoveryDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.GiDiscoveryDetails`
        * :class:`~oci.fleet_software_update.models.DbDiscoveryDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DiscoveryDetails.
            Allowed values for this property are: "DB", "GI", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this DiscoveryDetails.
            Allowed values for this property are: "EXACS", "EXACC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_type: str

        """
        self.swagger_types = {
            'type': 'str',
            'service_type': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'service_type': 'serviceType'
        }

        self._type = None
        self._service_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'GI':
            return 'GiDiscoveryDetails'

        if type == 'DB':
            return 'DbDiscoveryDetails'
        else:
            return 'DiscoveryDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DiscoveryDetails.
        Exadata Fleet Update Discovery type.

        Allowed values for this property are: "DB", "GI", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this DiscoveryDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DiscoveryDetails.
        Exadata Fleet Update Discovery type.


        :param type: The type of this DiscoveryDetails.
        :type: str
        """
        allowed_values = ["DB", "GI"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this DiscoveryDetails.
        Exadata service type for the target resource members.

        Allowed values for this property are: "EXACS", "EXACC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_type of this DiscoveryDetails.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this DiscoveryDetails.
        Exadata service type for the target resource members.


        :param service_type: The service_type of this DiscoveryDetails.
        :type: str
        """
        allowed_values = ["EXACS", "EXACC"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            service_type = 'UNKNOWN_ENUM_VALUE'
        self._service_type = service_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
