# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .llm_inference_request import LlmInferenceRequest
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlamaLlmInferenceRequest(LlmInferenceRequest):
    """
    Details for the text generation request for Llama models.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LlamaLlmInferenceRequest object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.LlamaLlmInferenceRequest.runtime_type` attribute
        of this class is ``LLAMA`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param runtime_type:
            The value to assign to the runtime_type property of this LlamaLlmInferenceRequest.
            Allowed values for this property are: "COHERE", "LLAMA"
        :type runtime_type: str

        :param prompt:
            The value to assign to the prompt property of this LlamaLlmInferenceRequest.
        :type prompt: str

        :param is_stream:
            The value to assign to the is_stream property of this LlamaLlmInferenceRequest.
        :type is_stream: bool

        :param num_generations:
            The value to assign to the num_generations property of this LlamaLlmInferenceRequest.
        :type num_generations: int

        :param is_echo:
            The value to assign to the is_echo property of this LlamaLlmInferenceRequest.
        :type is_echo: bool

        :param top_k:
            The value to assign to the top_k property of this LlamaLlmInferenceRequest.
        :type top_k: int

        :param top_p:
            The value to assign to the top_p property of this LlamaLlmInferenceRequest.
        :type top_p: float

        :param temperature:
            The value to assign to the temperature property of this LlamaLlmInferenceRequest.
        :type temperature: float

        :param frequency_penalty:
            The value to assign to the frequency_penalty property of this LlamaLlmInferenceRequest.
        :type frequency_penalty: float

        :param presence_penalty:
            The value to assign to the presence_penalty property of this LlamaLlmInferenceRequest.
        :type presence_penalty: float

        :param stop:
            The value to assign to the stop property of this LlamaLlmInferenceRequest.
        :type stop: list[str]

        :param log_probs:
            The value to assign to the log_probs property of this LlamaLlmInferenceRequest.
        :type log_probs: int

        :param max_tokens:
            The value to assign to the max_tokens property of this LlamaLlmInferenceRequest.
        :type max_tokens: int

        """
        self.swagger_types = {
            'runtime_type': 'str',
            'prompt': 'str',
            'is_stream': 'bool',
            'num_generations': 'int',
            'is_echo': 'bool',
            'top_k': 'int',
            'top_p': 'float',
            'temperature': 'float',
            'frequency_penalty': 'float',
            'presence_penalty': 'float',
            'stop': 'list[str]',
            'log_probs': 'int',
            'max_tokens': 'int'
        }

        self.attribute_map = {
            'runtime_type': 'runtimeType',
            'prompt': 'prompt',
            'is_stream': 'isStream',
            'num_generations': 'numGenerations',
            'is_echo': 'isEcho',
            'top_k': 'topK',
            'top_p': 'topP',
            'temperature': 'temperature',
            'frequency_penalty': 'frequencyPenalty',
            'presence_penalty': 'presencePenalty',
            'stop': 'stop',
            'log_probs': 'logProbs',
            'max_tokens': 'maxTokens'
        }

        self._runtime_type = None
        self._prompt = None
        self._is_stream = None
        self._num_generations = None
        self._is_echo = None
        self._top_k = None
        self._top_p = None
        self._temperature = None
        self._frequency_penalty = None
        self._presence_penalty = None
        self._stop = None
        self._log_probs = None
        self._max_tokens = None
        self._runtime_type = 'LLAMA'

    @property
    def prompt(self):
        """
        Gets the prompt of this LlamaLlmInferenceRequest.
        Represents the prompt to be completed. The trailing white spaces are trimmed before completion.


        :return: The prompt of this LlamaLlmInferenceRequest.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this LlamaLlmInferenceRequest.
        Represents the prompt to be completed. The trailing white spaces are trimmed before completion.


        :param prompt: The prompt of this LlamaLlmInferenceRequest.
        :type: str
        """
        self._prompt = prompt

    @property
    def is_stream(self):
        """
        Gets the is_stream of this LlamaLlmInferenceRequest.
        Whether to stream back partial progress. If set, tokens are sent as data-only server-sent events as they become available.


        :return: The is_stream of this LlamaLlmInferenceRequest.
        :rtype: bool
        """
        return self._is_stream

    @is_stream.setter
    def is_stream(self, is_stream):
        """
        Sets the is_stream of this LlamaLlmInferenceRequest.
        Whether to stream back partial progress. If set, tokens are sent as data-only server-sent events as they become available.


        :param is_stream: The is_stream of this LlamaLlmInferenceRequest.
        :type: bool
        """
        self._is_stream = is_stream

    @property
    def num_generations(self):
        """
        Gets the num_generations of this LlamaLlmInferenceRequest.
        The number of of generated texts that will be returned.


        :return: The num_generations of this LlamaLlmInferenceRequest.
        :rtype: int
        """
        return self._num_generations

    @num_generations.setter
    def num_generations(self, num_generations):
        """
        Sets the num_generations of this LlamaLlmInferenceRequest.
        The number of of generated texts that will be returned.


        :param num_generations: The num_generations of this LlamaLlmInferenceRequest.
        :type: int
        """
        self._num_generations = num_generations

    @property
    def is_echo(self):
        """
        Gets the is_echo of this LlamaLlmInferenceRequest.
        Whether or not to return the user prompt in the response. Applies only to non-stream results.


        :return: The is_echo of this LlamaLlmInferenceRequest.
        :rtype: bool
        """
        return self._is_echo

    @is_echo.setter
    def is_echo(self, is_echo):
        """
        Sets the is_echo of this LlamaLlmInferenceRequest.
        Whether or not to return the user prompt in the response. Applies only to non-stream results.


        :param is_echo: The is_echo of this LlamaLlmInferenceRequest.
        :type: bool
        """
        self._is_echo = is_echo

    @property
    def top_k(self):
        """
        Gets the top_k of this LlamaLlmInferenceRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is -1 which means to consider all tokens. Setting to 0 disables this method and considers all tokens.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :return: The top_k of this LlamaLlmInferenceRequest.
        :rtype: int
        """
        return self._top_k

    @top_k.setter
    def top_k(self, top_k):
        """
        Sets the top_k of this LlamaLlmInferenceRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is -1 which means to consider all tokens. Setting to 0 disables this method and considers all tokens.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :param top_k: The top_k of this LlamaLlmInferenceRequest.
        :type: int
        """
        self._top_k = top_k

    @property
    def top_p(self):
        """
        Gets the top_p of this LlamaLlmInferenceRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :return: The top_p of this LlamaLlmInferenceRequest.
        :rtype: float
        """
        return self._top_p

    @top_p.setter
    def top_p(self, top_p):
        """
        Sets the top_p of this LlamaLlmInferenceRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :param top_p: The top_p of this LlamaLlmInferenceRequest.
        :type: float
        """
        self._top_p = top_p

    @property
    def temperature(self):
        """
        Gets the temperature of this LlamaLlmInferenceRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :return: The temperature of this LlamaLlmInferenceRequest.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this LlamaLlmInferenceRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :param temperature: The temperature of this LlamaLlmInferenceRequest.
        :type: float
        """
        self._temperature = temperature

    @property
    def frequency_penalty(self):
        """
        Gets the frequency_penalty of this LlamaLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens. Set to 0 to disable.


        :return: The frequency_penalty of this LlamaLlmInferenceRequest.
        :rtype: float
        """
        return self._frequency_penalty

    @frequency_penalty.setter
    def frequency_penalty(self, frequency_penalty):
        """
        Sets the frequency_penalty of this LlamaLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens. Set to 0 to disable.


        :param frequency_penalty: The frequency_penalty of this LlamaLlmInferenceRequest.
        :type: float
        """
        self._frequency_penalty = frequency_penalty

    @property
    def presence_penalty(self):
        """
        Gets the presence_penalty of this LlamaLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :return: The presence_penalty of this LlamaLlmInferenceRequest.
        :rtype: float
        """
        return self._presence_penalty

    @presence_penalty.setter
    def presence_penalty(self, presence_penalty):
        """
        Sets the presence_penalty of this LlamaLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Values > 0 encourage the model to use new tokens and values < 0 encourage the model to repeat tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :param presence_penalty: The presence_penalty of this LlamaLlmInferenceRequest.
        :type: float
        """
        self._presence_penalty = presence_penalty

    @property
    def stop(self):
        """
        Gets the stop of this LlamaLlmInferenceRequest.
        List of strings that stop the generation if they are generated for the response text. The returned output will not contain the stop strings.


        :return: The stop of this LlamaLlmInferenceRequest.
        :rtype: list[str]
        """
        return self._stop

    @stop.setter
    def stop(self, stop):
        """
        Sets the stop of this LlamaLlmInferenceRequest.
        List of strings that stop the generation if they are generated for the response text. The returned output will not contain the stop strings.


        :param stop: The stop of this LlamaLlmInferenceRequest.
        :type: list[str]
        """
        self._stop = stop

    @property
    def log_probs(self):
        """
        Gets the log_probs of this LlamaLlmInferenceRequest.
        Includes the logarithmic probabilities for the most likely output tokens and the chosen tokens.

        For example, if the log probability is 5, the API returns a list of the 5 most likely tokens. The API returns the log probability of the sampled token, so there might be up to logprobs+1 elements in the response.


        :return: The log_probs of this LlamaLlmInferenceRequest.
        :rtype: int
        """
        return self._log_probs

    @log_probs.setter
    def log_probs(self, log_probs):
        """
        Sets the log_probs of this LlamaLlmInferenceRequest.
        Includes the logarithmic probabilities for the most likely output tokens and the chosen tokens.

        For example, if the log probability is 5, the API returns a list of the 5 most likely tokens. The API returns the log probability of the sampled token, so there might be up to logprobs+1 elements in the response.


        :param log_probs: The log_probs of this LlamaLlmInferenceRequest.
        :type: int
        """
        self._log_probs = log_probs

    @property
    def max_tokens(self):
        """
        Gets the max_tokens of this LlamaLlmInferenceRequest.
        The maximum number of tokens that can be generated per output sequence. The token count of the prompt plus `maxTokens` cannot exceed the model's context length.


        :return: The max_tokens of this LlamaLlmInferenceRequest.
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """
        Sets the max_tokens of this LlamaLlmInferenceRequest.
        The maximum number of tokens that can be generated per output sequence. The token count of the prompt plus `maxTokens` cannot exceed the model's context length.


        :param max_tokens: The max_tokens of this LlamaLlmInferenceRequest.
        :type: int
        """
        self._max_tokens = max_tokens

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
