# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FetchShardableCloudAutonomousVmClustersDetails(object):
    """
    Details required for fetch sharded cloud autonomous vm clusters.
    """

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FetchShardableCloudAutonomousVmClustersDetails.
    #: This constant has a value of "UNAVAILABLE"
    LIFECYCLE_STATE_UNAVAILABLE = "UNAVAILABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new FetchShardableCloudAutonomousVmClustersDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this FetchShardableCloudAutonomousVmClustersDetails.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FetchShardableCloudAutonomousVmClustersDetails.
            Allowed values for this property are: "ACTIVE", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "DELETING", "DELETED", "UPDATING", "CREATING", "UNAVAILABLE"
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this FetchShardableCloudAutonomousVmClustersDetails.
        :type lifecycle_state_details: str

        :param minimum_available_cdb_count:
            The value to assign to the minimum_available_cdb_count property of this FetchShardableCloudAutonomousVmClustersDetails.
        :type minimum_available_cdb_count: int

        :param are_depleted_clusters_included:
            The value to assign to the are_depleted_clusters_included property of this FetchShardableCloudAutonomousVmClustersDetails.
        :type are_depleted_clusters_included: bool

        :param regions:
            The value to assign to the regions property of this FetchShardableCloudAutonomousVmClustersDetails.
        :type regions: list[str]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'minimum_available_cdb_count': 'int',
            'are_depleted_clusters_included': 'bool',
            'regions': 'list[str]'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'minimum_available_cdb_count': 'minimumAvailableCdbCount',
            'are_depleted_clusters_included': 'areDepletedClustersIncluded',
            'regions': 'regions'
        }

        self._compartment_id = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._minimum_available_cdb_count = None
        self._are_depleted_clusters_included = None
        self._regions = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FetchShardableCloudAutonomousVmClustersDetails.
        Compartment id of cloud autonomous vm clusters.


        :return: The compartment_id of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FetchShardableCloudAutonomousVmClustersDetails.
        Compartment id of cloud autonomous vm clusters.


        :param compartment_id: The compartment_id of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this FetchShardableCloudAutonomousVmClustersDetails.
        Lifecycle states for shardable Cloud autonomous vm cluster.

        Allowed values for this property are: "ACTIVE", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "DELETING", "DELETED", "UPDATING", "CREATING", "UNAVAILABLE"


        :return: The lifecycle_state of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FetchShardableCloudAutonomousVmClustersDetails.
        Lifecycle states for shardable Cloud autonomous vm cluster.


        :param lifecycle_state: The lifecycle_state of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: str
        """
        allowed_values = ["ACTIVE", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "DELETING", "DELETED", "UPDATING", "CREATING", "UNAVAILABLE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this FetchShardableCloudAutonomousVmClustersDetails.
        Detailed message for the lifecycle state.


        :return: The lifecycle_state_details of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this FetchShardableCloudAutonomousVmClustersDetails.
        Detailed message for the lifecycle state.


        :param lifecycle_state_details: The lifecycle_state_details of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def minimum_available_cdb_count(self):
        """
        Gets the minimum_available_cdb_count of this FetchShardableCloudAutonomousVmClustersDetails.
        List only clusters for which atleast given minimum CDB count is available.


        :return: The minimum_available_cdb_count of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: int
        """
        return self._minimum_available_cdb_count

    @minimum_available_cdb_count.setter
    def minimum_available_cdb_count(self, minimum_available_cdb_count):
        """
        Sets the minimum_available_cdb_count of this FetchShardableCloudAutonomousVmClustersDetails.
        List only clusters for which atleast given minimum CDB count is available.


        :param minimum_available_cdb_count: The minimum_available_cdb_count of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: int
        """
        self._minimum_available_cdb_count = minimum_available_cdb_count

    @property
    def are_depleted_clusters_included(self):
        """
        Gets the are_depleted_clusters_included of this FetchShardableCloudAutonomousVmClustersDetails.
        Flag to indicate of response shall also include clusters for which no more capacity is left to create new resources.


        :return: The are_depleted_clusters_included of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: bool
        """
        return self._are_depleted_clusters_included

    @are_depleted_clusters_included.setter
    def are_depleted_clusters_included(self, are_depleted_clusters_included):
        """
        Sets the are_depleted_clusters_included of this FetchShardableCloudAutonomousVmClustersDetails.
        Flag to indicate of response shall also include clusters for which no more capacity is left to create new resources.


        :param are_depleted_clusters_included: The are_depleted_clusters_included of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: bool
        """
        self._are_depleted_clusters_included = are_depleted_clusters_included

    @property
    def regions(self):
        """
        Gets the regions of this FetchShardableCloudAutonomousVmClustersDetails.
        Region code of regions for which sharded cloud autonomous vm clusters need to be fetched.


        :return: The regions of this FetchShardableCloudAutonomousVmClustersDetails.
        :rtype: list[str]
        """
        return self._regions

    @regions.setter
    def regions(self, regions):
        """
        Sets the regions of this FetchShardableCloudAutonomousVmClustersDetails.
        Region code of regions for which sharded cloud autonomous vm clusters need to be fetched.


        :param regions: The regions of this FetchShardableCloudAutonomousVmClustersDetails.
        :type: list[str]
        """
        self._regions = regions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
